/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.secman.applib.user.dom.mixins;

import javax.inject.Inject;
import org.apache.causeway.applib.annotation.Action;
import org.apache.causeway.applib.annotation.ActionLayout;
import org.apache.causeway.applib.annotation.MemberSupport;
import org.apache.causeway.applib.annotation.SemanticsOf;
import org.apache.causeway.extensions.secman.applib.CausewayModuleExtSecmanApplib;
import org.apache.causeway.extensions.secman.applib.role.dom.ApplicationRole;
import org.apache.causeway.extensions.secman.applib.role.dom.ApplicationRoleRepository;
import org.apache.causeway.extensions.secman.applib.user.dom.ApplicationUser;
import org.apache.causeway.extensions.secman.applib.user.dom.ApplicationUserRepository;
import org.apache.causeway.extensions.secman.applib.user.dom.ApplicationUserStatus;
import org.springframework.lang.Nullable;

@Action(domainEvent=DomainEvent.class, semantics=SemanticsOf.NON_IDEMPOTENT)
@ActionLayout(associateWith="username", position=ActionLayout.Position.PANEL, sequence="1")
public class ApplicationUser_duplicate {
    @Inject
    private ApplicationUserRepository applicationUserRepository;
    @Inject
    private ApplicationRoleRepository applicationRoleRepository;
    private final ApplicationUser target;

    @MemberSupport
    public ApplicationUser act(String username, @Nullable String emailAddress) {
        return this.applicationUserRepository.newUser(username, this.target.getAccountType(), user -> {
            user.setStatus(ApplicationUserStatus.LOCKED);
            user.setEmailAddress(emailAddress);
            for (ApplicationRole role : this.target.getRoles()) {
                this.applicationRoleRepository.addRoleToUser(role, (ApplicationUser)user);
            }
        });
    }

    public ApplicationUser_duplicate(ApplicationUser target) {
        this.target = target;
    }

    public static class DomainEvent
    extends CausewayModuleExtSecmanApplib.ActionDomainEvent<ApplicationUser_duplicate> {
    }
}

