/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.secman.applib.user.dom;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.inject.Provider;
import lombok.NonNull;
import org.apache.causeway.applib.query.Query;
import org.apache.causeway.applib.services.eventbus.EventBusService;
import org.apache.causeway.applib.services.factory.FactoryService;
import org.apache.causeway.applib.services.queryresultscache.QueryResultsCache;
import org.apache.causeway.applib.services.repository.RepositoryService;
import org.apache.causeway.commons.internal.base._Casts;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.commons.internal.collections._Sets;
import org.apache.causeway.core.config.CausewayConfiguration;
import org.apache.causeway.extensions.secman.applib.role.dom.ApplicationRole;
import org.apache.causeway.extensions.secman.applib.tenancy.dom.ApplicationTenancy;
import org.apache.causeway.extensions.secman.applib.user.dom.AccountType;
import org.apache.causeway.extensions.secman.applib.user.dom.ApplicationUser;
import org.apache.causeway.extensions.secman.applib.user.dom.ApplicationUserRepository;
import org.apache.causeway.extensions.secman.applib.user.dom.ApplicationUserStatus;
import org.apache.causeway.extensions.secman.applib.user.dom.mixins.ApplicationUser_lock;
import org.apache.causeway.extensions.secman.applib.user.dom.mixins.ApplicationUser_unlock;
import org.apache.causeway.extensions.secman.applib.user.events.UserCreatedEvent;
import org.apache.causeway.extensions.secman.applib.util.RegexReplacer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.lang.Nullable;
import org.springframework.security.crypto.password.PasswordEncoder;

public class ApplicationUserRepositoryAbstract<U extends ApplicationUser>
implements ApplicationUserRepository {
    @Inject
    private FactoryService factoryService;
    @Inject
    private RepositoryService repository;
    @Inject
    protected CausewayConfiguration config;
    @Inject
    private EventBusService eventBusService;
    @Inject
    private RegexReplacer regexReplacer;
    @Inject
    private Provider<QueryResultsCache> queryResultsCacheProvider;
    @Autowired(required=false)
    @Qualifier(value="Secman")
    PasswordEncoder passwordEncoder;
    private final Class<U> applicationUserClass;

    protected ApplicationUserRepositoryAbstract(Class<U> applicationUserClass) {
        this.applicationUserClass = applicationUserClass;
    }

    @Override
    public ApplicationUser newApplicationUser() {
        return (ApplicationUser)this.factoryService.detachedEntity(this.applicationUserClass);
    }

    @Override
    public ApplicationUser findOrCreateUserByUsername(String username) {
        return (ApplicationUser)((QueryResultsCache)this.queryResultsCacheProvider.get()).execute(() -> this.findByUsername(username).orElseGet(() -> this.newDelegateUser(username, null)), ApplicationUserRepositoryAbstract.class, "findOrCreateUserByUsername", new Object[]{username});
    }

    public Optional<ApplicationUser> findByUsernameCached(String username) {
        return (Optional)((QueryResultsCache)this.queryResultsCacheProvider.get()).execute(this::findByUsername, ApplicationUserRepositoryAbstract.class, "findByUsernameCached", (Object)username);
    }

    @Override
    public Optional<ApplicationUser> findByUsername(String username) {
        return (Optional)_Casts.uncheckedCast((Object)this.repository.uniqueMatch((Query)Query.named(this.applicationUserClass, (String)"causeway.ext.secman.ApplicationUser.findByUsername").withParameter("username", (Object)username)));
    }

    public Optional<ApplicationUser> findByEmailAddressCached(String emailAddress) {
        return (Optional)((QueryResultsCache)this.queryResultsCacheProvider.get()).execute(this::findByEmailAddress, ApplicationUserRepositoryAbstract.class, "findByEmailAddressCached", (Object)emailAddress);
    }

    @Override
    public Optional<ApplicationUser> findByEmailAddress(String emailAddress) {
        return (Optional)_Casts.uncheckedCast((Object)this.repository.uniqueMatch((Query)Query.named(this.applicationUserClass, (String)"causeway.ext.secman.ApplicationUser.findByEmailAddress").withParameter("emailAddress", (Object)emailAddress)));
    }

    @Override
    public Collection<ApplicationUser> find(@Nullable String _search) {
        String regex = this.regexReplacer.asRegex(_search);
        return (Collection)this.repository.allMatches((Query)Query.named(this.applicationUserClass, (String)"causeway.ext.secman.ApplicationUser.find").withParameter("regex", (Object)regex)).stream().collect(_Sets.toUnmodifiableSorted());
    }

    @Override
    public Collection<ApplicationUser> findByAtPath(String atPath) {
        return (Collection)this.repository.allMatches((Query)Query.named(this.applicationUserClass, (String)"causeway.ext.secman.ApplicationUser.findByAtPath").withParameter("atPath", (Object)atPath)).stream().collect(_Sets.toUnmodifiableSorted());
    }

    @Override
    public Collection<ApplicationUser> findByRole(ApplicationRole role) {
        return (Collection)_NullSafe.stream(role.getUsers()).collect(_Sets.toUnmodifiableSorted());
    }

    @Override
    public Collection<ApplicationUser> findByTenancy(@NonNull ApplicationTenancy genericTenancy) {
        if (genericTenancy == null) {
            throw new NullPointerException("genericTenancy is marked non-null but is null");
        }
        return (Collection)this.findByAtPath(genericTenancy.getPath()).stream().collect(_Sets.toUnmodifiableSorted());
    }

    @Override
    public Collection<ApplicationUser> allUsers() {
        return (Collection)this.repository.allInstances(this.applicationUserClass).stream().collect(_Sets.toUnmodifiableSorted());
    }

    @Override
    public Collection<ApplicationUser> findMatching(String search) {
        if (search != null && search.length() > 0) {
            return this.find(search);
        }
        return Collections.emptySortedSet();
    }

    @Override
    public void enable(ApplicationUser user) {
        if (ApplicationUserStatus.canUnlock(user.getStatus())) {
            ((ApplicationUser_unlock)this.factoryService.mixin(ApplicationUser_unlock.class, (Object)user)).act();
        }
    }

    @Override
    public void disable(ApplicationUser user) {
        if (ApplicationUserStatus.canLock(user.getStatus())) {
            ((ApplicationUser_lock)this.factoryService.mixin(ApplicationUser_lock.class, (Object)user)).act();
        }
    }

    @Override
    public boolean isAdminUser(ApplicationUser user) {
        return Objects.equals(this.config.getExtensions().getSecman().getSeed().getAdmin().getUserName(), user.getName());
    }

    @Override
    public ApplicationUser newUser(@NonNull String username, @Nullable AccountType accountType, Consumer<ApplicationUser> beforePersist) {
        if (username == null) {
            throw new NullPointerException("username is marked non-null but is null");
        }
        ApplicationUser user = this.newApplicationUser();
        user.setUsername(username);
        user.setAccountType(accountType);
        beforePersist.accept(user);
        if (!user.getAccountType().equals((Object)AccountType.LOCAL)) {
            user.setStatus(ApplicationUserStatus.LOCKED);
        }
        this.repository.persistAndFlush((Object)user);
        this.eventBusService.post((Object)UserCreatedEvent.of(user));
        return user;
    }

    @Override
    public boolean updatePassword(ApplicationUser user, String password) {
        if (!this.isPasswordFeatureEnabled(user)) {
            return false;
        }
        user.setEncryptedPassword(this.passwordEncoder.encode((CharSequence)password));
        this.repository.persistAndFlush((Object)user);
        return true;
    }

    @Override
    public boolean isPasswordFeatureEnabled(ApplicationUser user) {
        return user.isLocalAccount() && this.passwordEncoder != null;
    }
}

