/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.secman.applib.user.dom;

import java.util.Collection;
import java.util.Optional;
import java.util.function.Consumer;
import lombok.NonNull;
import org.apache.causeway.applib.value.Password;
import org.apache.causeway.extensions.secman.applib.role.dom.ApplicationRole;
import org.apache.causeway.extensions.secman.applib.tenancy.dom.ApplicationTenancy;
import org.apache.causeway.extensions.secman.applib.user.dom.AccountType;
import org.apache.causeway.extensions.secman.applib.user.dom.ApplicationUser;
import org.apache.causeway.extensions.secman.applib.user.dom.ApplicationUserStatus;
import org.springframework.lang.Nullable;

public interface ApplicationUserRepository {
    public ApplicationUser newApplicationUser();

    public Optional<ApplicationUser> findByUsername(String var1);

    public ApplicationUser findOrCreateUserByUsername(String var1);

    public Collection<ApplicationUser> allUsers();

    public Collection<ApplicationUser> find(String var1);

    public Collection<ApplicationUser> findByAtPath(String var1);

    public Collection<ApplicationUser> findByRole(ApplicationRole var1);

    public Collection<ApplicationUser> findByTenancy(ApplicationTenancy var1);

    public Optional<ApplicationUser> findByEmailAddress(String var1);

    public Collection<ApplicationUser> findMatching(String var1);

    public void enable(ApplicationUser var1);

    public void disable(ApplicationUser var1);

    public boolean isAdminUser(ApplicationUser var1);

    public boolean isPasswordFeatureEnabled(ApplicationUser var1);

    public boolean updatePassword(ApplicationUser var1, String var2);

    public ApplicationUser newUser(String var1, AccountType var2, Consumer<ApplicationUser> var3);

    default public ApplicationUser upsertLocal(@NonNull String username, @Nullable Password password, @NonNull ApplicationUserStatus status) {
        if (username == null) {
            throw new NullPointerException("username is marked non-null but is null");
        }
        if (status == null) {
            throw new NullPointerException("status is marked non-null but is null");
        }
        return this.findByUsername(username).orElseGet(() -> this.newLocalUser(username, password, status));
    }

    default public ApplicationUser newLocalUser(@NonNull String username, @Nullable Password password, @NonNull ApplicationUserStatus status) {
        if (username == null) {
            throw new NullPointerException("username is marked non-null but is null");
        }
        if (status == null) {
            throw new NullPointerException("status is marked non-null but is null");
        }
        return this.newUser(username, AccountType.LOCAL, user -> {
            user.setStatus(status);
            if (password != null) {
                this.updatePassword((ApplicationUser)user, password.getPassword());
            }
        });
    }

    default public ApplicationUser newDelegateUser(String username, ApplicationUserStatus status) {
        return this.newUser(username, AccountType.DELEGATED, user -> user.setStatus(status));
    }
}

