/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.secman.applib.user.dom;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.causeway.applib.annotation.Collection;
import org.apache.causeway.applib.annotation.CollectionLayout;
import org.apache.causeway.applib.annotation.DomainObject;
import org.apache.causeway.applib.annotation.DomainObjectLayout;
import org.apache.causeway.applib.annotation.Editing;
import org.apache.causeway.applib.annotation.MemberSupport;
import org.apache.causeway.applib.annotation.ObjectSupport;
import org.apache.causeway.applib.annotation.Optionality;
import org.apache.causeway.applib.annotation.Parameter;
import org.apache.causeway.applib.annotation.ParameterLayout;
import org.apache.causeway.applib.annotation.Programmatic;
import org.apache.causeway.applib.annotation.Property;
import org.apache.causeway.applib.annotation.PropertyLayout;
import org.apache.causeway.applib.annotation.Where;
import org.apache.causeway.applib.mixins.security.HasUsername;
import org.apache.causeway.applib.services.user.RoleMemento;
import org.apache.causeway.applib.services.user.UserMemento;
import org.apache.causeway.applib.services.user.UserService;
import org.apache.causeway.applib.util.ObjectContracts;
import org.apache.causeway.commons.internal.assertions._Assert;
import org.apache.causeway.commons.internal.base._Casts;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.commons.internal.collections._Lists;
import org.apache.causeway.core.config.CausewayConfiguration;
import org.apache.causeway.extensions.secman.applib.CausewayModuleExtSecmanApplib;
import org.apache.causeway.extensions.secman.applib.permission.dom.ApplicationPermission;
import org.apache.causeway.extensions.secman.applib.permission.dom.ApplicationPermissionRepository;
import org.apache.causeway.extensions.secman.applib.permission.dom.ApplicationPermissionValueSet;
import org.apache.causeway.extensions.secman.applib.permission.spi.PermissionsEvaluationService;
import org.apache.causeway.extensions.secman.applib.role.dom.ApplicationRole;
import org.apache.causeway.extensions.secman.applib.tenancy.dom.HasAtPath;
import org.apache.causeway.extensions.secman.applib.user.dom.ApplicationUserRepository;
import org.apache.causeway.extensions.secman.applib.user.dom.ApplicationUserStatus;

@Named(value="causeway.ext.secman.ApplicationUser")
@DomainObject(autoCompleteRepository=ApplicationUserRepository.class, autoCompleteMethod="findMatching")
@DomainObjectLayout(titleUiEvent=TitleUiEvent.class, iconUiEvent=IconUiEvent.class, cssClassUiEvent=CssClassUiEvent.class, layoutUiEvent=LayoutUiEvent.class)
public abstract class ApplicationUser
implements HasUsername,
HasAtPath,
Comparable<ApplicationUser> {
    public static final String LOGICAL_TYPE_NAME = "causeway.ext.secman.ApplicationUser";
    public static final String SCHEMA = "causewayExtSecman";
    public static final String TABLE = "ApplicationUser";
    @Inject
    private transient ApplicationUserRepository applicationUserRepository;
    @Inject
    private transient ApplicationPermissionRepository applicationPermissionRepository;
    @Inject
    private transient UserService userService;
    @Inject
    private transient PermissionsEvaluationService permissionsEvaluationService;
    @Inject
    private transient CausewayConfiguration config;
    private transient ApplicationPermissionValueSet cachedPermissionSet;
    private static final String propertyNames = "username";
    private static final ObjectContracts.ObjectContract<ApplicationUser> contract = ObjectContracts.parse(ApplicationUser.class, (String)"username");

    @Programmatic
    protected ApplicationUserRepository getApplicationUserRepository() {
        return this.applicationUserRepository;
    }

    @Programmatic
    protected ApplicationPermissionRepository getApplicationPermissionRepository() {
        return this.applicationPermissionRepository;
    }

    @Programmatic
    protected UserService getUserService() {
        return this.userService;
    }

    @Programmatic
    protected PermissionsEvaluationService getPermissionsEvaluationService() {
        return this.permissionsEvaluationService;
    }

    @Programmatic
    protected CausewayConfiguration.Extensions.Secman getSecmanConfig() {
        return this.config.getExtensions().getSecman();
    }

    @ObjectSupport
    public String title() {
        return this.getName();
    }

    @ObjectSupport
    public String iconName() {
        return ApplicationUserStatus.isUnlocked(this.getStatus()) ? "unlocked" : "locked";
    }

    @Name
    public String getName() {
        StringBuilder buf = new StringBuilder();
        if (this.getFamilyName() != null) {
            if (this.getKnownAs() != null) {
                buf.append(this.getKnownAs());
            } else {
                buf.append(this.getGivenName());
            }
            buf.append(' ').append(this.getFamilyName()).append(" (").append(this.getUsername()).append(')');
        } else {
            buf.append(this.getUsername());
        }
        return buf.toString();
    }

    @Username
    public abstract String getUsername();

    public abstract void setUsername(String var1);

    @FamilyName
    public abstract String getFamilyName();

    public abstract void setFamilyName(String var1);

    @GivenName
    public abstract String getGivenName();

    public abstract void setGivenName(String var1);

    @KnownAs
    public abstract String getKnownAs();

    public abstract void setKnownAs(String var1);

    @EmailAddress
    public abstract String getEmailAddress();

    public abstract void setEmailAddress(String var1);

    @PhoneNumber
    public abstract String getPhoneNumber();

    public abstract void setPhoneNumber(String var1);

    @FaxNumber
    public abstract String getFaxNumber();

    public abstract void setFaxNumber(String var1);

    @Language
    public abstract java.util.Locale getLanguage();

    public abstract void setLanguage(java.util.Locale var1);

    @NumberFormat
    public abstract java.util.Locale getNumberFormat();

    public abstract void setNumberFormat(java.util.Locale var1);

    @TimeFormat
    public abstract java.util.Locale getTimeFormat();

    public abstract void setTimeFormat(java.util.Locale var1);

    @Override
    @AtPath
    public abstract String getAtPath();

    public abstract void setAtPath(String var1);

    @AccountType
    public abstract org.apache.causeway.extensions.secman.applib.user.dom.AccountType getAccountType();

    public abstract void setAccountType(org.apache.causeway.extensions.secman.applib.user.dom.AccountType var1);

    @Status
    public abstract ApplicationUserStatus getStatus();

    public abstract void setStatus(ApplicationUserStatus var1);

    @EncryptedPassword
    public abstract String getEncryptedPassword();

    public abstract void setEncryptedPassword(String var1);

    @MemberSupport
    public boolean hideEncryptedPassword() {
        return !this.getApplicationUserRepository().isPasswordFeatureEnabled(this);
    }

    @HasPassword
    public boolean isHasPassword() {
        return _Strings.isNotEmpty((CharSequence)this.getEncryptedPassword());
    }

    @MemberSupport
    public boolean hideHasPassword() {
        return !this.getApplicationUserRepository().isPasswordFeatureEnabled(this);
    }

    @Roles
    public abstract Set<ApplicationRole> getRoles();

    @Programmatic
    public ApplicationPermissionValueSet getPermissionSet() {
        if (this.cachedPermissionSet != null) {
            return this.cachedPermissionSet;
        }
        List<ApplicationPermission> permissions = this.userService.isImpersonating() ? this.getApplicationPermissionRepository().findByUserMemento(this.userService.getUser()) : this.getApplicationPermissionRepository().findByUser(this);
        this.cachedPermissionSet = new ApplicationPermissionValueSet(_Lists.map((java.util.Collection)((java.util.Collection)_Casts.uncheckedCast(permissions)), ApplicationPermission.Functions.AS_VALUE), this.getPermissionsEvaluationService());
        return this.cachedPermissionSet;
    }

    @Programmatic
    public boolean isForSelf() {
        UserMemento currentUser = this.currentUser();
        String currentUserName = currentUser.getName();
        boolean forSelf = Objects.equals(this.getUsername(), currentUserName);
        return forSelf;
    }

    @Programmatic
    public boolean isRunAsAdministrator() {
        UserMemento currentUser = this.currentUser();
        String adminRoleName = this.getAdminRoleName();
        String adminRoleSuffix = ":" + adminRoleName;
        for (RoleMemento role : currentUser.getRoles()) {
            String roleName = role.getName();
            if (adminRoleName.equals(roleName)) {
                return true;
            }
            if (!roleName.endsWith(adminRoleSuffix)) continue;
            return true;
        }
        return false;
    }

    @Programmatic
    public boolean isForSelfOrRunAsAdministrator() {
        return this.isForSelf() || this.isRunAsAdministrator();
    }

    @Programmatic
    public boolean isLocalAccount() {
        return this.getAccountType() == org.apache.causeway.extensions.secman.applib.user.dom.AccountType.LOCAL;
    }

    @Programmatic
    private String getAdminRoleName() {
        String adminRoleName = _Strings.emptyToNull((String)this.getSecmanConfig().getSeed().getAdmin().getRoleName());
        _Assert.assertNotNull((Object)adminRoleName, () -> "secman-config.seed.admin.role-name must not be empty");
        return adminRoleName;
    }

    @Programmatic
    private UserMemento currentUser() {
        return this.getUserService().currentUserElseFail();
    }

    @Override
    public int compareTo(ApplicationUser other) {
        return contract.compare((Object)this, (Object)other);
    }

    public boolean equals(Object obj) {
        return contract.equals((Object)this, obj);
    }

    public int hashCode() {
        return contract.hashCode((Object)this);
    }

    public String toString() {
        return contract.toString((Object)this);
    }

    @Collection(domainEvent=RolesDomainEvent.class)
    @CollectionLayout(defaultView="table", sequence="1")
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Roles {

        public static final class Persistence {
            public static final String TABLE = "ApplicationUserRoles";
            public static final String JOIN_COLUMN = "userId";
            public static final String INVERSE_JOIN_COLUMN = "roleId";

            private Persistence() {
                throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
            }
        }

        public static class RolesDomainEvent
        extends CollectionDomainEvent<ApplicationRole> {
        }
    }

    @Property(domainEvent=DomainEvent.class, editing=Editing.DISABLED)
    @PropertyLayout(fieldSetId="access", named="Has password?", sequence="3")
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface HasPassword {

        public static class DomainEvent
        extends PropertyDomainEvent<Boolean> {
        }
    }

    @Property
    @PropertyLayout(hidden=Where.EVERYWHERE)
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface EncryptedPassword {
        public static final int MAX_LENGTH = 255;
        public static final boolean NULLABLE = true;
        public static final String ALLOWS_NULL = "true";
    }

    @Property(domainEvent=DomainEvent.class, editing=Editing.DISABLED, optionality=Optionality.MANDATORY)
    @PropertyLayout(fieldSetId="access", sequence="1")
    @Parameter(optionality=Optionality.MANDATORY)
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Status {
        public static final boolean NULLABLE = false;
        public static final String ALLOWS_NULL = "false";

        public static class DomainEvent
        extends PropertyDomainEvent<ApplicationUserStatus> {
        }
    }

    @Property(domainEvent=DomainEvent.class, editing=Editing.DISABLED, optionality=Optionality.MANDATORY)
    @PropertyLayout(fieldSetId="access", sequence="2")
    @Parameter(optionality=Optionality.MANDATORY)
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface AccountType {
        public static final boolean NULLABLE = false;
        public static final String ALLOWS_NULL = "false";

        public static class DomainEvent
        extends PropertyDomainEvent<AccountType> {
        }
    }

    @Property(domainEvent=DomainEvent.class)
    @PropertyLayout(fieldSetId="access", sequence="4")
    @HasAtPath.AtPath
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface AtPath {
        public static final int MAX_LENGTH = 255;
        public static final boolean NULLABLE = true;
        public static final String ALLOWS_NULL = "true";

        public static class DomainEvent
        extends PropertyDomainEvent<String> {
        }
    }

    @Property(domainEvent=DomainEvent.class)
    @Locale
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface TimeFormat {
        public static final boolean NULLABLE = true;
        public static final String ALLOWS_NULL = "true";

        public static class DomainEvent
        extends Locale.DomainEvent {
        }
    }

    @Property(domainEvent=DomainEvent.class)
    @Locale
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface NumberFormat {
        public static final boolean NULLABLE = true;
        public static final String ALLOWS_NULL = "true";

        public static class DomainEvent
        extends Locale.DomainEvent {
        }
    }

    @Property(domainEvent=Locale.DomainEvent.class)
    @Locale
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Language {
        public static final boolean NULLABLE = true;
        public static final String ALLOWS_NULL = "true";

        public static class DomainEvent
        extends Locale.DomainEvent {
        }
    }

    @Property(domainEvent=DomainEvent.class, editing=Editing.DISABLED, optionality=Optionality.OPTIONAL)
    @PropertyLayout(fieldSetId="regional")
    @Parameter(optionality=Optionality.OPTIONAL)
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Locale {
        public static final boolean NULLABLE = true;
        public static final String ALLOWS_NULL = "true";

        public static class DomainEvent
        extends PropertyDomainEvent<java.util.Locale> {
        }
    }

    @Property(domainEvent=DomainEvent.class, editing=Editing.DISABLED, maxLength=120, optionality=Optionality.OPTIONAL)
    @PropertyLayout(fieldSetName="Contact Details", hidden=Where.PARENTED_TABLES, sequence="3.3")
    @Parameter(maxLength=120, optionality=Optionality.OPTIONAL)
    @ParameterLayout(named="Fax")
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface FaxNumber {
        public static final int MAX_LENGTH = 120;
        public static final boolean NULLABLE = true;
        public static final String ALLOWS_NULL = "true";

        public static class DomainEvent
        extends PropertyDomainEvent<String> {
        }
    }

    @Property(domainEvent=DomainEvent.class, editing=Editing.DISABLED, maxLength=120)
    @PropertyLayout(fieldSetName="Contact Details", sequence="3.2")
    @Parameter(maxLength=120, optionality=Optionality.OPTIONAL)
    @ParameterLayout(named="Phone")
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface PhoneNumber {
        public static final int MAX_LENGTH = 120;
        public static final boolean NULLABLE = true;
        public static final String ALLOWS_NULL = "true";

        public static class DomainEvent
        extends PropertyDomainEvent<String> {
        }
    }

    @Property(domainEvent=DomainEvent.class, editing=Editing.DISABLED, maxLength=120, optionality=Optionality.OPTIONAL)
    @PropertyLayout(fieldSetName="Contact Details", sequence="3.1")
    @Parameter(maxLength=120, optionality=Optionality.OPTIONAL)
    @ParameterLayout(named="Email")
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface EmailAddress {
        public static final int MAX_LENGTH = 120;
        public static final boolean NULLABLE = true;
        public static final String ALLOWS_NULL = "true";

        public static class DomainEvent
        extends PropertyDomainEvent<String> {
        }
    }

    @Property(domainEvent=KnownAsDomainEvent.class, editing=Editing.DISABLED, maxLength=120, optionality=Optionality.OPTIONAL)
    @PropertyLayout(fieldSetId="name", hidden=Where.ALL_TABLES, sequence="2.3")
    @Parameter(maxLength=120, optionality=Optionality.OPTIONAL)
    @ParameterLayout(named="Known As")
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface KnownAs {
        public static final int MAX_LENGTH = 120;
        public static final boolean NULLABLE = true;
        public static final String ALLOWS_NULL = "true";

        public static class KnownAsDomainEvent
        extends PropertyDomainEvent<String> {
        }
    }

    @Property(domainEvent=DomainEvent.class, editing=Editing.DISABLED, maxLength=120, optionality=Optionality.OPTIONAL)
    @PropertyLayout(fieldSetId="name", hidden=Where.ALL_TABLES, sequence="2.2")
    @Parameter(maxLength=120, optionality=Optionality.OPTIONAL)
    @ParameterLayout(named="Given Name")
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface GivenName {
        public static final int MAX_LENGTH = 120;
        public static final boolean NULLABLE = true;
        public static final String ALLOWS_NULL = "true";

        public static class DomainEvent
        extends PropertyDomainEvent<String> {
        }
    }

    @Property(domainEvent=DomainEvent.class, editing=Editing.DISABLED, maxLength=120, optionality=Optionality.OPTIONAL)
    @PropertyLayout(fieldSetId="name", hidden=Where.ALL_TABLES, sequence="2.1")
    @Parameter(maxLength=120, optionality=Optionality.OPTIONAL)
    @ParameterLayout(named="Family Name")
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface FamilyName {
        public static final int MAX_LENGTH = 120;
        public static final boolean NULLABLE = true;
        public static final String ALLOWS_NULL = "true";

        public static class DomainEvent
        extends PropertyDomainEvent<String> {
        }
    }

    @Property(domainEvent=DomainEvent.class)
    @PropertyLayout(fieldSetId="identity", hidden=Where.PARENTED_TABLES, sequence="1")
    @HasUsername.Username
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Username {
        public static final int MAX_LENGTH = 120;
        public static final boolean NULLABLE = false;
        public static final String ALLOWS_NULL = "false";

        public static class DomainEvent
        extends PropertyDomainEvent<String> {
        }
    }

    @Property(domainEvent=DomainEvent.class, editing=Editing.DISABLED)
    @PropertyLayout(hidden=Where.OBJECT_FORMS, fieldSetId="identity", sequence="1")
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Name {

        public static class DomainEvent
        extends PropertyDomainEvent<String> {
        }
    }

    public static abstract class CollectionDomainEvent<T>
    extends CausewayModuleExtSecmanApplib.CollectionDomainEvent<ApplicationUser, T> {
    }

    public static abstract class PropertyDomainEvent<T>
    extends CausewayModuleExtSecmanApplib.PropertyDomainEvent<ApplicationUser, T> {
    }

    public static class LayoutUiEvent
    extends CausewayModuleExtSecmanApplib.LayoutUiEvent<ApplicationUser> {
    }

    public static class CssClassUiEvent
    extends CausewayModuleExtSecmanApplib.CssClassUiEvent<ApplicationUser> {
    }

    public static class IconUiEvent
    extends CausewayModuleExtSecmanApplib.IconUiEvent<ApplicationUser> {
    }

    public static class TitleUiEvent
    extends CausewayModuleExtSecmanApplib.TitleUiEvent<ApplicationUser> {
    }

    public static final class Nq {
        public static final String FIND_BY_USERNAME = "causeway.ext.secman.ApplicationUser.findByUsername";
        public static final String FIND_BY_EMAIL_ADDRESS = "causeway.ext.secman.ApplicationUser.findByEmailAddress";
        public static final String FIND = "causeway.ext.secman.ApplicationUser.find";
        public static final String FIND_BY_ATPATH = "causeway.ext.secman.ApplicationUser.findByAtPath";

        private Nq() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }
}

