/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.secman.applib.user.contributions;

import javax.inject.Inject;
import org.apache.causeway.applib.annotation.Action;
import org.apache.causeway.applib.annotation.ActionLayout;
import org.apache.causeway.applib.annotation.MemberSupport;
import org.apache.causeway.applib.annotation.SemanticsOf;
import org.apache.causeway.applib.mixins.security.HasUsername;
import org.apache.causeway.applib.services.i18n.TranslatableString;
import org.apache.causeway.extensions.secman.applib.CausewayModuleExtSecmanApplib;
import org.apache.causeway.extensions.secman.applib.user.dom.ApplicationUser;
import org.apache.causeway.extensions.secman.applib.user.dom.ApplicationUserRepository;

@Action(semantics=SemanticsOf.SAFE, domainEvent=ActionDomainEvent.class)
@ActionLayout(associateWith="user", sequence="1")
public class HasUsername_associatedUser {
    @Inject
    private ApplicationUserRepository applicationUserRepository;
    private final HasUsername target;

    @MemberSupport
    public ApplicationUser act() {
        if (this.target == null || this.target.getUsername() == null) {
            return null;
        }
        return this.applicationUserRepository.findByUsername(this.target.getUsername()).orElse(null);
    }

    @MemberSupport
    public boolean hideAct() {
        return this.target instanceof ApplicationUser;
    }

    @MemberSupport
    public TranslatableString disableAct() {
        return this.target == null || this.target.getUsername() == null ? TranslatableString.tr((String)"No username", (Object[])new Object[0]) : null;
    }

    public HasUsername_associatedUser(HasUsername target) {
        this.target = target;
    }

    public static class ActionDomainEvent
    extends CausewayModuleExtSecmanApplib.ActionDomainEvent<HasUsername_associatedUser> {
    }
}

