/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.secman.applib.tenancy.dom.mixins;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.causeway.applib.annotation.Action;
import org.apache.causeway.applib.annotation.ActionLayout;
import org.apache.causeway.applib.annotation.MemberSupport;
import org.apache.causeway.applib.annotation.SemanticsOf;
import org.apache.causeway.commons.internal.collections._Lists;
import org.apache.causeway.extensions.secman.applib.CausewayModuleExtSecmanApplib;
import org.apache.causeway.extensions.secman.applib.tenancy.dom.ApplicationTenancy;
import org.apache.causeway.extensions.secman.applib.tenancy.dom.ApplicationTenancyRepository;

@Action(domainEvent=DomainEvent.class, semantics=SemanticsOf.IDEMPOTENT)
@ActionLayout(associateWith="children", named="Add", sequence="1")
public class ApplicationTenancy_addChild {
    @Inject
    private ApplicationTenancyRepository applicationTenancyRepository;
    private final ApplicationTenancy target;

    @MemberSupport
    public ApplicationTenancy act(ApplicationTenancy child) {
        this.applicationTenancyRepository.setParentOnTenancy(child, this.target);
        return this.target;
    }

    @MemberSupport
    public Collection<? extends ApplicationTenancy> choicesChild() {
        ArrayList choices = _Lists.newArrayList(this.applicationTenancyRepository.getRootTenancies());
        choices.removeIf(this::containsTarget);
        return choices;
    }

    @MemberSupport
    public String disableAct() {
        return this.choicesChild().isEmpty() ? "No root (non-paranted) tenancies available" : null;
    }

    private boolean containsTarget(ApplicationTenancy t) {
        for (ApplicationTenancy node = t; node != null; node = node.getParent()) {
            if (!Objects.equals(node, this.target)) continue;
            return true;
        }
        return false;
    }

    public ApplicationTenancy_addChild(ApplicationTenancy target) {
        this.target = target;
    }

    public static class DomainEvent
    extends CausewayModuleExtSecmanApplib.ActionDomainEvent<ApplicationTenancy_addChild> {
    }
}

