/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.secman.applib.tenancy.dom;

import java.util.Collection;
import java.util.Collections;
import javax.inject.Inject;
import javax.inject.Provider;
import lombok.NonNull;
import org.apache.causeway.applib.query.Query;
import org.apache.causeway.applib.services.factory.FactoryService;
import org.apache.causeway.applib.services.queryresultscache.QueryResultsCache;
import org.apache.causeway.applib.services.repository.RepositoryService;
import org.apache.causeway.commons.internal.collections._Sets;
import org.apache.causeway.extensions.secman.applib.tenancy.dom.ApplicationTenancy;
import org.apache.causeway.extensions.secman.applib.tenancy.dom.ApplicationTenancyRepository;
import org.apache.causeway.extensions.secman.applib.user.dom.ApplicationUser;
import org.apache.causeway.extensions.secman.applib.util.RegexReplacer;

public abstract class ApplicationTenancyRepositoryAbstract<T extends ApplicationTenancy>
implements ApplicationTenancyRepository {
    @Inject
    private FactoryService factory;
    @Inject
    private RepositoryService repository;
    @Inject
    private RegexReplacer regexReplacer;
    @Inject
    private Provider<QueryResultsCache> queryResultsCacheProvider;
    private final Class<T> applicationTenancyClass;

    protected ApplicationTenancyRepositoryAbstract(Class<T> applicationTenancyClass) {
        this.applicationTenancyClass = applicationTenancyClass;
    }

    @Override
    public ApplicationTenancy newApplicationTenancy() {
        return (ApplicationTenancy)this.factory.detachedEntity(this.applicationTenancyClass);
    }

    @Override
    public Collection<ApplicationTenancy> findByNameOrPathMatchingCached(String search) {
        return (Collection)((QueryResultsCache)this.queryResultsCacheProvider.get()).execute(() -> this.findByNameOrPathMatching(search), ApplicationTenancyRepositoryAbstract.class, "findByNameOrPathMatchingCached", new Object[]{search});
    }

    public Collection<ApplicationTenancy> findByNameOrPathMatching(String search) {
        if (search == null) {
            return Collections.emptySortedSet();
        }
        String regex = this.regexReplacer.asRegex(search);
        return (Collection)this.repository.allMatches((Query)Query.named(this.applicationTenancyClass, (String)"causeway.ext.secman.ApplicationTenancy.findByNameOrPathMatching").withParameter("regex", (Object)regex)).stream().collect(_Sets.toUnmodifiableSorted());
    }

    public ApplicationTenancy findByNameCached(String name) {
        return (ApplicationTenancy)((QueryResultsCache)this.queryResultsCacheProvider.get()).execute(() -> this.findByName(name), ApplicationTenancyRepositoryAbstract.class, "findByNameCached", new Object[]{name});
    }

    public ApplicationTenancy findByName(String name) {
        return this.repository.uniqueMatch((Query)Query.named(this.applicationTenancyClass, (String)"causeway.ext.secman.ApplicationTenancy.findByName").withParameter("name", (Object)name)).orElse(null);
    }

    public ApplicationTenancy findByPathCached(String path) {
        return (ApplicationTenancy)((QueryResultsCache)this.queryResultsCacheProvider.get()).execute(() -> this.findByPath(path), ApplicationTenancyRepositoryAbstract.class, "findByPathCached", new Object[]{path});
    }

    @Override
    public ApplicationTenancy findByPath(String path) {
        if (path == null) {
            return null;
        }
        return this.repository.uniqueMatch((Query)Query.named(this.applicationTenancyClass, (String)"causeway.ext.secman.ApplicationTenancy.findByPath").withParameter("path", (Object)path)).orElse(null);
    }

    @Override
    public Collection<ApplicationTenancy> findMatching(String search) {
        if (search != null && search.length() > 0) {
            return this.findByNameOrPathMatching(search);
        }
        return Collections.emptySortedSet();
    }

    @Override
    public ApplicationTenancy newTenancy(String name, String path, ApplicationTenancy parent) {
        ApplicationTenancy tenancy = this.findByPath(path);
        if (tenancy == null) {
            tenancy = this.newApplicationTenancy();
            tenancy.setName(name);
            tenancy.setPath(path);
            tenancy.setParent(parent);
            if (parent != null) {
                parent.getChildren().add(tenancy);
            }
            this.repository.persistAndFlush((Object)tenancy);
        }
        return tenancy;
    }

    @Override
    public Collection<ApplicationTenancy> allTenancies() {
        return (Collection)((QueryResultsCache)this.queryResultsCacheProvider.get()).execute(() -> this.allTenanciesNoCache(), ApplicationTenancyRepositoryAbstract.class, "allTenancies");
    }

    public Collection<ApplicationTenancy> allTenanciesNoCache() {
        return (Collection)this.repository.allInstances(this.applicationTenancyClass).stream().map(this.applicationTenancyClass::cast).collect(_Sets.toUnmodifiableSorted());
    }

    @Override
    public Collection<ApplicationTenancy> getRootTenancies() {
        return (Collection)this.repository.allInstances(this.applicationTenancyClass).stream().filter(ApplicationTenancy::isRoot).map(this.applicationTenancyClass::cast).collect(_Sets.toUnmodifiableSorted());
    }

    @Override
    public Collection<ApplicationTenancy> getChildren(@NonNull ApplicationTenancy tenancy) {
        if (tenancy == null) {
            throw new NullPointerException("tenancy is marked non-null but is null");
        }
        return (Collection)tenancy.getChildren().stream().collect(_Sets.toUnmodifiableSorted());
    }

    @Override
    public void setTenancyOnUser(@NonNull ApplicationTenancy tenancy, @NonNull ApplicationUser user) {
        if (tenancy == null) {
            throw new NullPointerException("tenancy is marked non-null but is null");
        }
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        user.setAtPath(tenancy.getPath());
    }

    @Override
    public void clearTenancyOnUser(@NonNull ApplicationUser user) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        user.setAtPath(null);
    }

    @Override
    public void setParentOnTenancy(@NonNull ApplicationTenancy tenancy, @NonNull ApplicationTenancy parent) {
        if (tenancy == null) {
            throw new NullPointerException("tenancy is marked non-null but is null");
        }
        if (parent == null) {
            throw new NullPointerException("parent is marked non-null but is null");
        }
        tenancy.setParent(parent);
        parent.getChildren().add(tenancy);
    }

    @Override
    public void clearParentOnTenancy(@NonNull ApplicationTenancy tenancy) {
        if (tenancy == null) {
            throw new NullPointerException("tenancy is marked non-null but is null");
        }
        ApplicationTenancy parent = tenancy.getParent();
        if (parent != null) {
            parent.getChildren().remove(tenancy);
            tenancy.setParent(null);
        }
    }
}

