/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.secman.applib.tenancy.dom;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collection;
import java.util.Comparator;
import javax.inject.Named;
import org.apache.causeway.applib.annotation.CollectionLayout;
import org.apache.causeway.applib.annotation.DomainObject;
import org.apache.causeway.applib.annotation.DomainObjectLayout;
import org.apache.causeway.applib.annotation.Editing;
import org.apache.causeway.applib.annotation.ObjectSupport;
import org.apache.causeway.applib.annotation.Optionality;
import org.apache.causeway.applib.annotation.Parameter;
import org.apache.causeway.applib.annotation.ParameterLayout;
import org.apache.causeway.applib.annotation.Programmatic;
import org.apache.causeway.applib.annotation.Property;
import org.apache.causeway.applib.annotation.PropertyLayout;
import org.apache.causeway.applib.annotation.Where;
import org.apache.causeway.applib.util.Equality;
import org.apache.causeway.applib.util.Hashing;
import org.apache.causeway.applib.util.ObjectContracts;
import org.apache.causeway.applib.util.ToString;
import org.apache.causeway.extensions.secman.applib.CausewayModuleExtSecmanApplib;
import org.apache.causeway.extensions.secman.applib.tenancy.dom.ApplicationTenancyRepository;
import org.apache.causeway.extensions.secman.applib.tenancy.dom.HasAtPath;

@Named(value="causeway.ext.secman.ApplicationTenancy")
@DomainObject(autoCompleteRepository=ApplicationTenancyRepository.class, autoCompleteMethod="findMatching")
@DomainObjectLayout(titleUiEvent=TitleUiEvent.class, iconUiEvent=IconUiEvent.class, cssClassUiEvent=CssClassUiEvent.class, layoutUiEvent=LayoutUiEvent.class)
public abstract class ApplicationTenancy
implements Comparable<ApplicationTenancy> {
    public static final String LOGICAL_TYPE_NAME = "causeway.ext.secman.ApplicationTenancy";
    public static final String SCHEMA = "causewayExtSecman";
    public static final String TABLE = "ApplicationTenancy";
    private static final Equality<ApplicationTenancy> equality = ObjectContracts.checkEquals(ApplicationTenancy::getPath);
    private static final Hashing<ApplicationTenancy> hashing = ObjectContracts.hashing(ApplicationTenancy::getPath);
    private static final ToString<ApplicationTenancy> toString = ObjectContracts.toString((String)"path", ApplicationTenancy::getPath).thenToString("name", ApplicationTenancy::getName);
    private static final Comparator<ApplicationTenancy> comparator = Comparator.comparing(ApplicationTenancy::getPath);

    @ObjectSupport
    public String title() {
        return this.getName();
    }

    @Name
    public abstract String getName();

    public abstract void setName(String var1);

    @Path
    public abstract String getPath();

    public abstract void setPath(String var1);

    @Parent
    public abstract ApplicationTenancy getParent();

    public abstract void setParent(ApplicationTenancy var1);

    @Programmatic
    public boolean isRoot() {
        return this.getParent() == null;
    }

    @Children
    public abstract Collection<ApplicationTenancy> getChildren();

    @Override
    public int compareTo(ApplicationTenancy other) {
        return comparator.compare(this, other);
    }

    public boolean equals(Object other) {
        return equality.equals((Object)this, other);
    }

    public int hashCode() {
        return hashing.hashCode((Object)this);
    }

    public String toString() {
        return toString.toString((Object)this);
    }

    @org.apache.causeway.applib.annotation.Collection(domainEvent=DomainEvent.class)
    @CollectionLayout(defaultView="table")
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Children {
        public static final String MAPPED_BY = "parent";

        public static class DomainEvent
        extends CollectionDomainEvent<ApplicationTenancy> {
        }
    }

    @Property(domainEvent=DomainEvent.class, editing=Editing.DISABLED)
    @PropertyLayout(fieldSetId="details", hidden=Where.REFERENCES_PARENT, sequence="2")
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Parent {
        public static final String NAME = "parentPath";
        public static final boolean NULLABLE = true;
        public static final String ALLOWS_NULL = "true";

        public static class DomainEvent
        extends PropertyDomainEvent<ApplicationTenancy> {
        }
    }

    @Property(domainEvent=Parent.DomainEvent.class, optionality=Optionality.MANDATORY)
    @PropertyLayout(fieldSetId="identity")
    @HasAtPath.AtPath
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Path {
        public static final int MAX_LENGTH = 255;
        public static final boolean NULLABLE = false;
        public static final String ALLOWS_NULL = "false";

        public static class DomainEvent
        extends PropertyDomainEvent<String> {
        }
    }

    @Property(domainEvent=DomainEvent.class, editing=Editing.DISABLED, maxLength=120)
    @PropertyLayout(fieldSetId="details", sequence="1", typicalLength=20)
    @Parameter(maxLength=120)
    @ParameterLayout(named="Name", typicalLength=20)
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Name {
        public static final int MAX_LENGTH = 120;
        public static final int TYPICAL_LENGTH = 20;
        public static final boolean NULLABLE = false;
        public static final String ALLOWS_NULL = "false";

        public static class DomainEvent
        extends PropertyDomainEvent<String> {
        }
    }

    public static abstract class ActionDomainEvent
    extends CausewayModuleExtSecmanApplib.ActionDomainEvent<ApplicationTenancy> {
    }

    public static abstract class CollectionDomainEvent<T>
    extends CausewayModuleExtSecmanApplib.CollectionDomainEvent<ApplicationTenancy, T> {
    }

    public static abstract class PropertyDomainEvent<T>
    extends CausewayModuleExtSecmanApplib.PropertyDomainEvent<ApplicationTenancy, T> {
    }

    public static class LayoutUiEvent
    extends CausewayModuleExtSecmanApplib.LayoutUiEvent<ApplicationTenancy> {
    }

    public static class CssClassUiEvent
    extends CausewayModuleExtSecmanApplib.CssClassUiEvent<ApplicationTenancy> {
    }

    public static class IconUiEvent
    extends CausewayModuleExtSecmanApplib.IconUiEvent<ApplicationTenancy> {
    }

    public static class TitleUiEvent
    extends CausewayModuleExtSecmanApplib.TitleUiEvent<ApplicationTenancy> {
    }

    public static final class Nq {
        public static final String FIND_BY_NAME = "causeway.ext.secman.ApplicationTenancy.findByName";
        public static final String FIND_BY_PATH = "causeway.ext.secman.ApplicationTenancy.findByPath";
        public static final String FIND_BY_NAME_OR_PATH_MATCHING = "causeway.ext.secman.ApplicationTenancy.findByNameOrPathMatching";

        private Nq() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }
}

