/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.secman.applib.seed;

import javax.inject.Inject;
import javax.inject.Named;
import org.apache.causeway.applib.events.metamodel.MetamodelEvent;
import org.apache.causeway.applib.services.iactnlayer.InteractionService;
import org.apache.causeway.extensions.secman.applib.seed.scripts.SeedUsersAndRolesFixtureScript;
import org.apache.causeway.testing.fixtures.applib.fixturescripts.FixtureScript;
import org.apache.causeway.testing.fixtures.applib.fixturescripts.FixtureScripts;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Service
@Named(value="causeway.ext.secman.SeedSecurityModuleService")
@Qualifier(value="Default")
public class SeedSecurityModuleService {
    private static final Logger log = LogManager.getLogger(SeedSecurityModuleService.class);
    private final FixtureScripts fixtureScripts;
    private final InteractionService interactionService;

    @EventListener(value={MetamodelEvent.class})
    @Order(value=1073741723)
    public void onMetamodelEvent(MetamodelEvent event) {
        log.debug("received metamodel event {}", (Object)event);
        if (event.isPostMetamodel()) {
            log.info("SEED security fixtures (Users and Roles)");
            this.interactionService.runAnonymous(() -> this.fixtureScripts.run(new FixtureScript[]{new SeedUsersAndRolesFixtureScript()}));
        }
    }

    @Inject
    public SeedSecurityModuleService(FixtureScripts fixtureScripts, InteractionService interactionService) {
        this.fixtureScripts = fixtureScripts;
        this.interactionService = interactionService;
    }
}

