/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.secman.applib.role.seed;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.causeway.applib.services.appfeat.ApplicationFeatureId;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.core.config.CausewayConfiguration;
import org.apache.causeway.extensions.secman.applib.permission.dom.ApplicationPermissionMode;
import org.apache.causeway.extensions.secman.applib.permission.dom.ApplicationPermissionRule;
import org.apache.causeway.extensions.secman.applib.role.fixtures.AbstractRoleAndPermissionsFixtureScript;
import org.apache.causeway.testing.fixtures.applib.fixturescripts.FixtureScript;

public class CausewayExtSecmanAdminRoleAndPermissions
extends AbstractRoleAndPermissionsFixtureScript {
    private final Set<String> adminInitialPackagePermissions;

    public CausewayExtSecmanAdminRoleAndPermissions(CausewayConfiguration.Extensions.Secman config) {
        super(config.getSeed().getAdmin().getRoleName(), "Administer security");
        this.adminInitialPackagePermissions = CausewayExtSecmanAdminRoleAndPermissions.streamAdminNamespacePermissions(config).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    protected void execute(FixtureScript.ExecutionContext executionContext) {
        this.newPermissions(ApplicationPermissionRule.ALLOW, ApplicationPermissionMode.CHANGING, (Can<ApplicationFeatureId>)Can.of((Object[])new String[]{"causeway.ext.secman"}).addAll(Can.ofCollection(this.adminInitialPackagePermissions)).map(ApplicationFeatureId::newNamespace));
    }

    private static Stream<String> streamAdminNamespacePermissions(CausewayConfiguration.Extensions.Secman secman) {
        CausewayConfiguration.Extensions.Secman.Seed.Admin.NamespacePermissions adminNamespacePermissions = secman.getSeed().getAdmin().getNamespacePermissions();
        return Stream.concat(_NullSafe.stream((Collection)adminNamespacePermissions.getSticky()), _NullSafe.stream((Collection)adminNamespacePermissions.getAdditional()));
    }
}

