/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.secman.applib.role.menu;

import java.util.Collection;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.causeway.applib.annotation.Action;
import org.apache.causeway.applib.annotation.ActionLayout;
import org.apache.causeway.applib.annotation.DomainService;
import org.apache.causeway.applib.annotation.DomainServiceLayout;
import org.apache.causeway.applib.annotation.MemberSupport;
import org.apache.causeway.applib.annotation.NatureOfService;
import org.apache.causeway.applib.annotation.ObjectSupport;
import org.apache.causeway.applib.annotation.Parameter;
import org.apache.causeway.applib.annotation.ParameterLayout;
import org.apache.causeway.applib.annotation.SemanticsOf;
import org.apache.causeway.applib.services.factory.FactoryService;
import org.apache.causeway.extensions.secman.applib.CausewayModuleExtSecmanApplib;
import org.apache.causeway.extensions.secman.applib.role.dom.ApplicationRole;
import org.apache.causeway.extensions.secman.applib.role.dom.ApplicationRoleRepository;
import org.apache.causeway.extensions.secman.applib.role.man.ApplicationRoleManager;

@Named(value="causeway.ext.secman.ApplicationRoleMenu")
@DomainService(nature=NatureOfService.VIEW)
@DomainServiceLayout(named="Security", menuBar=DomainServiceLayout.MenuBar.SECONDARY)
@Priority(value=0x1FFFFFFF)
public class ApplicationRoleMenu {
    public static final String LOGICAL_TYPE_NAME = "causeway.ext.secman.ApplicationRoleMenu";
    private final ApplicationRoleRepository applicationRoleRepository;
    private final FactoryService factory;

    @ObjectSupport
    public String iconName() {
        return "applicationRole";
    }

    @Inject
    public ApplicationRoleMenu(ApplicationRoleRepository applicationRoleRepository, FactoryService factory) {
        this.applicationRoleRepository = applicationRoleRepository;
        this.factory = factory;
    }

    @Action(domainEvent=ActionDomainEvent.class, semantics=SemanticsOf.SAFE)
    @ActionLayout(sequence="100.20.2")
    public class findRoles {
        @MemberSupport
        public Collection<? extends ApplicationRole> act(@Parameter(maxLength=120) @ParameterLayout(named="Search", typicalLength=30) String search) {
            return ApplicationRoleMenu.this.applicationRoleRepository.findNameContaining(search);
        }

        public class ActionDomainEvent
        extends org.apache.causeway.extensions.secman.applib.role.menu.ApplicationRoleMenu$ActionDomainEvent<findRoles> {
        }
    }

    @Action(domainEvent=ActionDomainEvent.class, semantics=SemanticsOf.IDEMPOTENT)
    @ActionLayout(sequence="100.20.1", cssClassFa="user-tag")
    public class roleManager {
        @MemberSupport
        public ApplicationRoleManager act() {
            return (ApplicationRoleManager)ApplicationRoleMenu.this.factory.viewModel((Object)new ApplicationRoleManager());
        }

        public class ActionDomainEvent
        extends org.apache.causeway.extensions.secman.applib.role.menu.ApplicationRoleMenu$ActionDomainEvent<roleManager> {
        }
    }

    public static abstract class ActionDomainEvent<T>
    extends CausewayModuleExtSecmanApplib.ActionDomainEvent<T> {
    }
}

