/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.secman.applib.role.fixtures;

import java.util.function.Supplier;
import javax.inject.Inject;
import org.apache.causeway.applib.services.appfeat.ApplicationFeatureId;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.extensions.secman.applib.permission.dom.ApplicationPermissionMode;
import org.apache.causeway.extensions.secman.applib.permission.dom.ApplicationPermissionRepository;
import org.apache.causeway.extensions.secman.applib.permission.dom.ApplicationPermissionRule;
import org.apache.causeway.extensions.secman.applib.role.dom.ApplicationRole;
import org.apache.causeway.extensions.secman.applib.role.dom.ApplicationRoleRepository;
import org.apache.causeway.testing.fixtures.applib.fixturescripts.FixtureScript;

public abstract class AbstractRoleAndPermissionsFixtureScript
extends FixtureScript {
    @Inject
    private ApplicationRoleRepository applicationRoleRepository;
    @Inject
    private ApplicationPermissionRepository applicationPermissionRepository;
    private final Supplier<String> roleNameSupplier;
    private final Supplier<String> roleDescriptionSupplier;

    protected AbstractRoleAndPermissionsFixtureScript(String roleName, String roleDescriptionIfAny) {
        this(() -> roleName, () -> roleDescriptionIfAny);
    }

    protected AbstractRoleAndPermissionsFixtureScript(Supplier<String> roleNameSupplier, Supplier<String> roleDescriptionSupplier) {
        this.roleNameSupplier = AbstractRoleAndPermissionsFixtureScript.nullSafe(roleNameSupplier);
        this.roleDescriptionSupplier = AbstractRoleAndPermissionsFixtureScript.nullSafe(roleDescriptionSupplier);
    }

    protected final String getRoleName() {
        return this.roleNameSupplier.get();
    }

    protected final String getRoleDescription() {
        return this.roleDescriptionSupplier.get();
    }

    protected abstract void execute(FixtureScript.ExecutionContext var1);

    protected void newPermissions(ApplicationPermissionRule rule, ApplicationPermissionMode mode, Can<ApplicationFeatureId> featureIds) {
        if (featureIds == null || featureIds.isEmpty()) {
            return;
        }
        String roleName = this.getRoleName();
        ApplicationRole securityRole = this.applicationRoleRepository.findByName(roleName).orElseGet(() -> this.applicationRoleRepository.newRole(roleName, this.getRoleDescription()));
        for (ApplicationFeatureId featureId : featureIds) {
            String featureFqn = featureId.getFullyQualifiedName();
            this.applicationPermissionRepository.newPermissionNoCheck(securityRole, rule, mode, featureId.getSort(), featureFqn);
        }
    }

    private static <T> Supplier<T> nullSafe(Supplier<T> supplier) {
        return supplier != null ? supplier : () -> null;
    }
}

