/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.secman.applib.role.dom.mixins;

import java.util.Collection;
import javax.inject.Inject;
import org.apache.causeway.applib.annotation.Action;
import org.apache.causeway.applib.annotation.ActionLayout;
import org.apache.causeway.applib.annotation.Domain;
import org.apache.causeway.applib.annotation.MemberSupport;
import org.apache.causeway.applib.annotation.SemanticsOf;
import org.apache.causeway.applib.services.message.MessageService;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.extensions.secman.applib.CausewayModuleExtSecmanApplib;
import org.apache.causeway.extensions.secman.applib.role.dom.ApplicationRole;
import org.apache.causeway.extensions.secman.applib.role.dom.ApplicationRoleRepository;
import org.apache.causeway.extensions.secman.applib.user.dom.ApplicationUser;
import org.apache.causeway.extensions.secman.applib.user.dom.ApplicationUserRepository;

@Action(choicesFrom="users", domainEvent=DomainEvent.class, semantics=SemanticsOf.IDEMPOTENT)
@ActionLayout(associateWith="users", named="Remove", sequence="2")
public class ApplicationRole_removeUsers {
    @Inject
    private MessageService messageService;
    @Inject
    private ApplicationRoleRepository applicationRoleRepository;
    @Inject
    private ApplicationUserRepository applicationUserRepository;
    private final ApplicationRole target;

    @MemberSupport
    public ApplicationRole act(Collection<ApplicationUser> users) {
        _NullSafe.stream(users).filter(this::canRemove).forEach(user -> this.applicationRoleRepository.removeRoleFromUser(this.target, (ApplicationUser)user));
        return this.target;
    }

    @Domain.Exclude
    boolean canRemove(ApplicationUser applicationUser) {
        if (this.applicationUserRepository.isAdminUser(applicationUser) && this.applicationRoleRepository.isAdminRole(this.target)) {
            this.messageService.warnUser("Cannot remove admin user from the admin role.");
            return false;
        }
        return true;
    }

    public ApplicationRole_removeUsers(ApplicationRole target) {
        this.target = target;
    }

    public static class DomainEvent
    extends CausewayModuleExtSecmanApplib.ActionDomainEvent<ApplicationRole_removeUsers> {
    }
}

