/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.secman.applib.role.dom.mixins;

import java.util.Collection;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.causeway.applib.annotation.Action;
import org.apache.causeway.applib.annotation.ActionLayout;
import org.apache.causeway.applib.annotation.MemberSupport;
import org.apache.causeway.applib.annotation.PromptStyle;
import org.apache.causeway.applib.annotation.SemanticsOf;
import org.apache.causeway.applib.services.message.MessageService;
import org.apache.causeway.applib.services.repository.RepositoryService;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.core.config.CausewayConfiguration;
import org.apache.causeway.extensions.secman.applib.CausewayModuleExtSecmanApplib;
import org.apache.causeway.extensions.secman.applib.permission.dom.ApplicationPermission;
import org.apache.causeway.extensions.secman.applib.role.dom.ApplicationRole;
import org.apache.causeway.extensions.secman.applib.role.dom.ApplicationRoleRepository;

@Action(choicesFrom="permissions", domainEvent=DomainEvent.class, semantics=SemanticsOf.IDEMPOTENT)
@ActionLayout(associateWith="permissions", named="Remove", promptStyle=PromptStyle.DIALOG_MODAL, sequence="2")
public class ApplicationRole_removePermissions {
    @Inject
    private MessageService messageService;
    @Inject
    private CausewayConfiguration config;
    @Inject
    private RepositoryService repository;
    @Inject
    private ApplicationRoleRepository applicationRoleRepository;
    private final ApplicationRole target;

    @MemberSupport
    public ApplicationRole act(Collection<ApplicationPermission> permissions) {
        _NullSafe.stream(permissions).filter(this::canRemove).forEach(arg_0 -> ((RepositoryService)this.repository).remove(arg_0));
        return this.target;
    }

    private boolean canRemove(ApplicationPermission permission) {
        if (!Objects.equals(permission.getRole(), this.target)) {
            return false;
        }
        if (this.applicationRoleRepository.isAdminRole(this.target) && ApplicationRole_removePermissions.isStickyAdminNamespace(this.config.getExtensions().getSecman(), permission.getFeatureFqn())) {
            this.messageService.warnUser("Cannot remove top-level namespace permissions for the admin role.");
            return false;
        }
        return true;
    }

    private static boolean isStickyAdminNamespace(CausewayConfiguration.Extensions.Secman secman, String featureFqn) {
        CausewayConfiguration.Extensions.Secman.Seed.Admin.NamespacePermissions adminNamespacePermissions = secman.getSeed().getAdmin().getNamespacePermissions();
        return _NullSafe.stream((Collection)adminNamespacePermissions.getSticky()).anyMatch(stickyPackage -> stickyPackage.equals(featureFqn));
    }

    public ApplicationRole_removePermissions(ApplicationRole target) {
        this.target = target;
    }

    public static class DomainEvent
    extends CausewayModuleExtSecmanApplib.ActionDomainEvent<ApplicationRole_removePermissions> {
    }
}

