/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.secman.applib.role.dom.mixins;

import java.util.Collection;
import javax.inject.Inject;
import org.apache.causeway.applib.annotation.Action;
import org.apache.causeway.applib.annotation.ActionLayout;
import org.apache.causeway.applib.annotation.MemberSupport;
import org.apache.causeway.applib.annotation.MinLength;
import org.apache.causeway.applib.annotation.ParameterLayout;
import org.apache.causeway.applib.annotation.PromptStyle;
import org.apache.causeway.applib.annotation.SemanticsOf;
import org.apache.causeway.extensions.secman.applib.CausewayModuleExtSecmanApplib;
import org.apache.causeway.extensions.secman.applib.feature.api.ApplicationFeatureChoices;
import org.apache.causeway.extensions.secman.applib.permission.dom.ApplicationPermissionMode;
import org.apache.causeway.extensions.secman.applib.permission.dom.ApplicationPermissionRepository;
import org.apache.causeway.extensions.secman.applib.permission.dom.ApplicationPermissionRule;
import org.apache.causeway.extensions.secman.applib.role.dom.ApplicationRole;

@Action(domainEvent=DomainEvent.class, semantics=SemanticsOf.NON_IDEMPOTENT)
@ActionLayout(associateWith="permissions", named="Add", promptStyle=PromptStyle.DIALOG_MODAL, sequence="1")
public class ApplicationRole_addPermission {
    @Inject
    private ApplicationPermissionRepository applicationPermissionRepository;
    @Inject
    private ApplicationFeatureChoices applicationFeatureChoices;
    private final ApplicationRole target;

    @MemberSupport
    public ApplicationRole act(ApplicationPermissionRule rule, ApplicationPermissionMode mode, @ParameterLayout(describedAs="To refine the search by feature-sort (namespace, type, member), use one of n: t: m:") ApplicationFeatureChoices.AppFeat feature) {
        this.applicationPermissionRepository.newPermission(this.target, rule, mode, feature.getFeatureId());
        return this.target;
    }

    @MemberSupport
    public ApplicationPermissionRule defaultRule(Parameters params) {
        return ApplicationPermissionRule.ALLOW;
    }

    @MemberSupport
    public ApplicationPermissionMode defaultMode(Parameters params) {
        return ApplicationPermissionMode.CHANGING;
    }

    @MemberSupport
    public Collection<ApplicationFeatureChoices.AppFeat> autoCompleteFeature(Parameters params, @MinLength(value=3) String search) {
        return this.applicationFeatureChoices.autoCompleteFeature(search);
    }

    public ApplicationRole_addPermission(ApplicationRole target) {
        this.target = target;
    }

    public static final class Parameters {
        private final ApplicationPermissionRule rule;
        private final ApplicationPermissionMode mode;
        private final ApplicationFeatureChoices.AppFeat feature;

        public Parameters(ApplicationPermissionRule rule, ApplicationPermissionMode mode, ApplicationFeatureChoices.AppFeat feature) {
            this.rule = rule;
            this.mode = mode;
            this.feature = feature;
        }

        public ApplicationPermissionRule rule() {
            return this.rule;
        }

        public ApplicationPermissionMode mode() {
            return this.mode;
        }

        public ApplicationFeatureChoices.AppFeat feature() {
            return this.feature;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Parameters)) {
                return false;
            }
            Parameters other = (Parameters)o;
            ApplicationPermissionRule this$rule = this.rule();
            ApplicationPermissionRule other$rule = other.rule();
            if (this$rule == null ? other$rule != null : !((Object)((Object)this$rule)).equals((Object)other$rule)) {
                return false;
            }
            ApplicationPermissionMode this$mode = this.mode();
            ApplicationPermissionMode other$mode = other.mode();
            if (this$mode == null ? other$mode != null : !((Object)((Object)this$mode)).equals((Object)other$mode)) {
                return false;
            }
            ApplicationFeatureChoices.AppFeat this$feature = this.feature();
            ApplicationFeatureChoices.AppFeat other$feature = other.feature();
            return !(this$feature == null ? other$feature != null : !((Object)this$feature).equals(other$feature));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ApplicationPermissionRule $rule = this.rule();
            result = result * 59 + ($rule == null ? 43 : ((Object)((Object)$rule)).hashCode());
            ApplicationPermissionMode $mode = this.mode();
            result = result * 59 + ($mode == null ? 43 : ((Object)((Object)$mode)).hashCode());
            ApplicationFeatureChoices.AppFeat $feature = this.feature();
            result = result * 59 + ($feature == null ? 43 : ((Object)$feature).hashCode());
            return result;
        }

        public String toString() {
            return "ApplicationRole_addPermission.Parameters(rule=" + this.rule() + ", mode=" + this.mode() + ", feature=" + this.feature() + ")";
        }
    }

    public static class DomainEvent
    extends CausewayModuleExtSecmanApplib.ActionDomainEvent<ApplicationRole_addPermission> {
    }
}

