/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.secman.applib.role.dom;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.apache.causeway.applib.query.Query;
import org.apache.causeway.applib.services.factory.FactoryService;
import org.apache.causeway.applib.services.queryresultscache.QueryResultsCache;
import org.apache.causeway.applib.services.repository.RepositoryService;
import org.apache.causeway.commons.internal.base._Casts;
import org.apache.causeway.commons.internal.collections._Sets;
import org.apache.causeway.core.config.CausewayConfiguration;
import org.apache.causeway.extensions.secman.applib.permission.dom.ApplicationPermission;
import org.apache.causeway.extensions.secman.applib.permission.dom.mixins.ApplicationPermission_delete;
import org.apache.causeway.extensions.secman.applib.role.dom.ApplicationRole;
import org.apache.causeway.extensions.secman.applib.role.dom.ApplicationRoleRepository;
import org.apache.causeway.extensions.secman.applib.user.dom.ApplicationUser;
import org.apache.causeway.extensions.secman.applib.util.RegexReplacer;
import org.springframework.stereotype.Repository;

@Repository
@Named(value="causeway.ext.secman.ApplicationRoleRepository")
public abstract class ApplicationRoleRepositoryAbstract<R extends ApplicationRole>
implements ApplicationRoleRepository {
    @Inject
    private FactoryService factoryService;
    @Inject
    private RepositoryService repository;
    @Inject
    private CausewayConfiguration config;
    @Inject
    private RegexReplacer regexReplacer;
    @Inject
    private Provider<QueryResultsCache> queryResultsCacheProvider;
    private final Class<R> applicationRoleClass;

    protected ApplicationRoleRepositoryAbstract(Class<R> applicationRoleClass) {
        this.applicationRoleClass = applicationRoleClass;
    }

    @Override
    public ApplicationRole newApplicationRole() {
        return (ApplicationRole)this.factoryService.detachedEntity(this.applicationRoleClass);
    }

    @Override
    public Optional<ApplicationRole> findByNameCached(String name) {
        return (Optional)((QueryResultsCache)this.queryResultsCacheProvider.get()).execute(() -> this.findByName(name), ApplicationRoleRepositoryAbstract.class, "findByNameCached", new Object[]{name});
    }

    @Override
    public ApplicationRole upsert(String name, String roleDescription) {
        return this.findByName(name).orElseGet(() -> this.newRole(name, roleDescription));
    }

    @Override
    public Optional<ApplicationRole> findByName(String name) {
        if (name == null) {
            return Optional.empty();
        }
        return (Optional)_Casts.uncheckedCast((Object)this.repository.uniqueMatch((Query)Query.named(this.applicationRoleClass, (String)"causeway.ext.secman.ApplicationRole.findByName").withParameter("name", (Object)name)));
    }

    @Override
    public Collection<ApplicationRole> findNameContaining(String search) {
        if (search != null && search.length() > 0) {
            String nameRegex = this.regexReplacer.asRegex(search);
            return (Collection)this.repository.allMatches((Query)Query.named(this.applicationRoleClass, (String)"causeway.ext.secman.ApplicationRole.findByNameContaining").withParameter("regex", (Object)nameRegex)).stream().collect(_Sets.toUnmodifiableSorted());
        }
        return Collections.emptySortedSet();
    }

    @Override
    public ApplicationRole newRole(String name, String description) {
        ApplicationRole role = this.findByName(name).orElse(null);
        if (role == null) {
            role = this.newApplicationRole();
            role.setName(name);
            role.setDescription(description);
            this.repository.persist((Object)role);
        }
        return role;
    }

    @Override
    public Collection<ApplicationRole> allRoles() {
        return (Collection)this.repository.allInstances(this.applicationRoleClass).stream().collect(_Sets.toUnmodifiableSorted());
    }

    @Override
    public Collection<ApplicationRole> findMatching(String search) {
        if (search != null && search.length() > 0) {
            return this.findNameContaining(search);
        }
        return Collections.emptySortedSet();
    }

    @Override
    public void addRoleToUser(ApplicationRole role, ApplicationUser user) {
        user.getRoles().add(role);
        role.getUsers().add(user);
        this.repository.persistAndFlush(new Object[]{user, role});
    }

    @Override
    public void removeRoleFromUser(ApplicationRole role, ApplicationUser user) {
        user.getRoles().remove(role);
        role.getUsers().remove(user);
        this.repository.persistAndFlush(new Object[]{user, role});
    }

    @Override
    public boolean isAdminRole(ApplicationRole genericRole) {
        String adminRoleName = this.config.getExtensions().getSecman().getSeed().getAdmin().getRoleName();
        ApplicationRole adminRole = this.findByNameCached(adminRoleName).orElse(null);
        return Objects.equals(adminRole, genericRole);
    }

    @Override
    public void deleteRole(ApplicationRole role) {
        role.getUsers().clear();
        List<ApplicationPermission> permissions = role.getPermissions();
        for (ApplicationPermission permission : permissions) {
            ApplicationPermission_delete deleteMixin = (ApplicationPermission_delete)this.factoryService.mixin(ApplicationPermission_delete.class, (Object)permission);
            deleteMixin.act();
        }
        this.repository.removeAndFlush((Object)role);
    }

    @Override
    public Collection<ApplicationRole> getRoles(ApplicationUser user) {
        return user.getRoles();
    }
}

