/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.secman.applib.role.dom;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.causeway.applib.annotation.Collection;
import org.apache.causeway.applib.annotation.CollectionLayout;
import org.apache.causeway.applib.annotation.DomainObject;
import org.apache.causeway.applib.annotation.DomainObjectLayout;
import org.apache.causeway.applib.annotation.Editing;
import org.apache.causeway.applib.annotation.ObjectSupport;
import org.apache.causeway.applib.annotation.Optionality;
import org.apache.causeway.applib.annotation.Parameter;
import org.apache.causeway.applib.annotation.ParameterLayout;
import org.apache.causeway.applib.annotation.Property;
import org.apache.causeway.applib.annotation.PropertyLayout;
import org.apache.causeway.applib.util.Equality;
import org.apache.causeway.applib.util.Hashing;
import org.apache.causeway.applib.util.ObjectContracts;
import org.apache.causeway.applib.util.ToString;
import org.apache.causeway.extensions.secman.applib.CausewayModuleExtSecmanApplib;
import org.apache.causeway.extensions.secman.applib.permission.dom.ApplicationPermission;
import org.apache.causeway.extensions.secman.applib.permission.dom.ApplicationPermissionRepository;
import org.apache.causeway.extensions.secman.applib.role.dom.ApplicationRoleRepository;
import org.apache.causeway.extensions.secman.applib.user.dom.ApplicationUser;

@Named(value="causeway.ext.secman.ApplicationRole")
@DomainObject(autoCompleteRepository=ApplicationRoleRepository.class, autoCompleteMethod="findMatching")
@DomainObjectLayout(titleUiEvent=TitleUiEvent.class, iconUiEvent=IconUiEvent.class, cssClassUiEvent=CssClassUiEvent.class, layoutUiEvent=LayoutUiEvent.class)
public abstract class ApplicationRole
implements Comparable<ApplicationRole> {
    public static final String LOGICAL_TYPE_NAME = "causeway.ext.secman.ApplicationRole";
    public static final String SCHEMA = "causewayExtSecman";
    public static final String TABLE = "ApplicationRole";
    @Inject
    private transient ApplicationPermissionRepository applicationPermissionRepository;
    private static final Comparator<ApplicationRole> comparator = Comparator.comparing(ApplicationRole::getName);
    private static final Equality<ApplicationRole> equality = ObjectContracts.checkEquals(ApplicationRole::getName);
    private static final Hashing<ApplicationRole> hashing = ObjectContracts.hashing(ApplicationRole::getName);
    private static final ToString<ApplicationRole> toString = ObjectContracts.toString((String)"name", ApplicationRole::getName);

    @ObjectSupport
    public String title() {
        return this.getName();
    }

    @Name
    public abstract String getName();

    public abstract void setName(String var1);

    @Description
    public abstract String getDescription();

    public abstract void setDescription(String var1);

    @Users
    public abstract Set<ApplicationUser> getUsers();

    @Permissions
    public List<ApplicationPermission> getPermissions() {
        return this.applicationPermissionRepository.findByRole(this);
    }

    @Override
    public int compareTo(ApplicationRole other) {
        return comparator.compare(this, other);
    }

    public boolean equals(Object obj) {
        return equality.equals((Object)this, obj);
    }

    public int hashCode() {
        return hashing.hashCode((Object)this);
    }

    public String toString() {
        return toString.toString((Object)this);
    }

    @Collection(domainEvent=DomainEvent.class)
    @CollectionLayout(defaultView="table", sequence="10", sortedBy=ApplicationPermission.DefaultComparator.class)
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Permissions {

        public static class DomainEvent
        extends CollectionDomainEvent<ApplicationPermission> {
        }
    }

    @Collection(domainEvent=DomainEvent.class)
    @CollectionLayout(defaultView="table", sequence="20")
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Users {
        public static final String MAPPED_BY = "roles";

        public static class DomainEvent
        extends CollectionDomainEvent<ApplicationUser> {
        }
    }

    @Property(domainEvent=DomainEvent.class, editing=Editing.DISABLED, maxLength=254, optionality=Optionality.OPTIONAL)
    @PropertyLayout(fieldSetId="details", sequence="1", typicalLength=50)
    @Parameter(maxLength=254, optionality=Optionality.OPTIONAL)
    @ParameterLayout(multiLine=5, named="Description", typicalLength=50)
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Description {
        public static final int MAX_LENGTH = 254;
        public static final int TYPICAL_LENGTH = 50;
        public static final boolean NULLABLE = true;
        public static final String ALLOWS_NULL = "true";

        public static class DomainEvent
        extends PropertyDomainEvent<String> {
        }
    }

    @Property(domainEvent=DomainEvent.class, editing=Editing.DISABLED, maxLength=120)
    @PropertyLayout(fieldSetId="identity", sequence="1", typicalLength=30)
    @Parameter(maxLength=120)
    @ParameterLayout(named="Name", typicalLength=30)
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Name {
        public static final int MAX_LENGTH = 120;
        public static final int TYPICAL_LENGTH = 30;
        public static final boolean NULLABLE = false;
        public static final String ALLOWS_NULL = "false";

        public static class DomainEvent
        extends PropertyDomainEvent<String> {
        }
    }

    public static abstract class CollectionDomainEvent<T>
    extends CausewayModuleExtSecmanApplib.CollectionDomainEvent<ApplicationRole, T> {
    }

    public static abstract class PropertyDomainEvent<T>
    extends CausewayModuleExtSecmanApplib.PropertyDomainEvent<ApplicationRole, T> {
    }

    public static class LayoutUiEvent
    extends CausewayModuleExtSecmanApplib.LayoutUiEvent<ApplicationRole> {
    }

    public static class CssClassUiEvent
    extends CausewayModuleExtSecmanApplib.CssClassUiEvent<ApplicationRole> {
    }

    public static class IconUiEvent
    extends CausewayModuleExtSecmanApplib.IconUiEvent<ApplicationRole> {
    }

    public static class TitleUiEvent
    extends CausewayModuleExtSecmanApplib.TitleUiEvent<ApplicationRole> {
    }

    public static final class Nq {
        public static final String FIND_BY_NAME = "causeway.ext.secman.ApplicationRole.findByName";
        public static final String FIND_BY_NAME_CONTAINING = "causeway.ext.secman.ApplicationRole.findByNameContaining";

        private Nq() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }
}

