/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.secman.applib.permission.dom;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.causeway.applib.annotation.Programmatic;
import org.apache.causeway.applib.services.appfeat.ApplicationFeatureId;
import org.apache.causeway.commons.internal.collections._Lists;
import org.apache.causeway.commons.internal.collections._Multimaps;
import org.apache.causeway.extensions.secman.applib.CausewayModuleExtSecmanApplib;
import org.apache.causeway.extensions.secman.applib.permission.dom.ApplicationPermissionMode;
import org.apache.causeway.extensions.secman.applib.permission.dom.ApplicationPermissionValue;
import org.apache.causeway.extensions.secman.applib.permission.spi.PermissionsEvaluationService;

public class ApplicationPermissionValueSet
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<ApplicationPermissionValue> values;
    private final _Multimaps.SetMultimap<ApplicationFeatureId, ApplicationPermissionValue> permissionsByFeature = _Multimaps.newSortedSetMultimap(Collections.reverseOrder(), null);
    private PermissionsEvaluationService permissionsEvaluationService;

    public ApplicationPermissionValueSet(List<ApplicationPermissionValue> permissionValues, PermissionsEvaluationService permissionsEvaluationService) {
        this.values = Collections.unmodifiableList(_Lists.newArrayList(permissionValues));
        for (ApplicationPermissionValue permissionValue : permissionValues) {
            ApplicationFeatureId featureId = permissionValue.getFeatureId();
            this.permissionsByFeature.putElement((Object)featureId, (Object)permissionValue);
        }
        this.permissionsEvaluationService = permissionsEvaluationService;
    }

    @Programmatic
    public boolean grants(ApplicationFeatureId featureId, ApplicationPermissionMode mode) {
        return this.evaluate(featureId, mode).isGranted();
    }

    @Programmatic
    public Evaluation evaluate(ApplicationFeatureId featureId, ApplicationPermissionMode mode) {
        for (ApplicationFeatureId pathId : featureId.getPathIds()) {
            Set permissionValues = (Set)this.permissionsByFeature.get((Object)pathId);
            Evaluation evaluation = this.permissionsEvaluationService.evaluate(featureId, mode, permissionValues);
            if (evaluation == null) continue;
            return evaluation;
        }
        return new Evaluation(null, false);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationPermissionValueSet that = (ApplicationPermissionValueSet)o;
        return !(this.values == null ? that.values != null : !this.values.equals(that.values));
    }

    public int hashCode() {
        return this.values != null ? this.values.hashCode() : 0;
    }

    public String toString() {
        return "ApplicationPermissionValueSet{values=" + this.values + "}";
    }

    public static class Evaluation {
        private final ApplicationPermissionValue permissionValue;
        private final boolean granted;

        public Evaluation(ApplicationPermissionValue permissionValue, boolean granted) {
            this.permissionValue = permissionValue;
            this.granted = granted;
        }

        public ApplicationPermissionValue getCause() {
            return this.permissionValue;
        }

        public boolean isGranted() {
            return this.granted;
        }
    }

    public static abstract class ActionDomainEvent
    extends CausewayModuleExtSecmanApplib.ActionDomainEvent<ApplicationPermissionValueSet> {
    }

    public static abstract class CollectionDomainEvent<T>
    extends CausewayModuleExtSecmanApplib.CollectionDomainEvent<ApplicationPermissionValueSet, T> {
    }

    public static abstract class PropertyDomainEvent<T>
    extends CausewayModuleExtSecmanApplib.PropertyDomainEvent<ApplicationPermissionValueSet, T> {
    }
}

