/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.secman.applib.permission.dom;

import java.io.Serializable;
import java.util.Comparator;
import org.apache.causeway.applib.annotation.Programmatic;
import org.apache.causeway.applib.services.appfeat.ApplicationFeatureId;
import org.apache.causeway.applib.util.ObjectContracts;
import org.apache.causeway.applib.util.ToString;
import org.apache.causeway.extensions.secman.applib.permission.dom.ApplicationPermissionMode;
import org.apache.causeway.extensions.secman.applib.permission.dom.ApplicationPermissionRule;

public class ApplicationPermissionValue
implements Comparable<ApplicationPermissionValue>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ApplicationFeatureId featureId;
    private final ApplicationPermissionRule rule;
    private final ApplicationPermissionMode mode;
    private static final Comparator<ApplicationPermissionValue> comparator = Comparator.comparing(ApplicationPermissionValue::getRule).thenComparing(ApplicationPermissionValue::getMode).thenComparing(ApplicationPermissionValue::getFeatureId);
    private static final ToString<ApplicationPermissionValue> toString = ObjectContracts.toString((String)"name", ApplicationPermissionValue::getRule).thenToString("mode", ApplicationPermissionValue::getMode).thenToString("featureId", ApplicationPermissionValue::getFeatureId);

    public ApplicationPermissionValue(ApplicationFeatureId featureId, ApplicationPermissionRule rule, ApplicationPermissionMode mode) {
        this.featureId = featureId;
        this.rule = rule;
        this.mode = mode;
    }

    @Programmatic
    public ApplicationFeatureId getFeatureId() {
        return this.featureId;
    }

    @Programmatic
    public ApplicationPermissionRule getRule() {
        return this.rule;
    }

    @Programmatic
    public ApplicationPermissionMode getMode() {
        return this.mode;
    }

    @Programmatic
    public boolean implies(ApplicationFeatureId featureId, ApplicationPermissionMode mode) {
        if (this.getRule() != ApplicationPermissionRule.ALLOW) {
            return false;
        }
        if (this.getMode() == ApplicationPermissionMode.VIEWING && mode == ApplicationPermissionMode.CHANGING) {
            return false;
        }
        return this.onPathOf(featureId);
    }

    @Programmatic
    public boolean refutes(ApplicationFeatureId featureId, ApplicationPermissionMode mode) {
        if (this.getRule() != ApplicationPermissionRule.VETO) {
            return false;
        }
        if (this.getMode() == ApplicationPermissionMode.CHANGING && mode == ApplicationPermissionMode.VIEWING) {
            return false;
        }
        return this.onPathOf(featureId);
    }

    private boolean onPathOf(ApplicationFeatureId featureId) {
        for (ApplicationFeatureId pathId : featureId.getPathIds()) {
            if (!this.getFeatureId().equals((Object)pathId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(ApplicationPermissionValue o) {
        return comparator.compare(this, o);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationPermissionValue that = (ApplicationPermissionValue)o;
        if (this.featureId != null ? !this.featureId.equals((Object)that.featureId) : that.featureId != null) {
            return false;
        }
        if (this.mode != that.mode) {
            return false;
        }
        return this.rule == that.rule;
    }

    public int hashCode() {
        int result = this.featureId != null ? this.featureId.hashCode() : 0;
        result = 31 * result + (this.rule != null ? this.rule.hashCode() : 0);
        result = 31 * result + (this.mode != null ? this.mode.hashCode() : 0);
        return result;
    }

    public String toString() {
        return toString.toString((Object)this);
    }

    public static final class Comparators {
        private Comparators() {
        }

        public static Comparator<ApplicationPermissionValue> natural() {
            return new ApplicationPermissionValueComparator();
        }

        static class ApplicationPermissionValueComparator
        implements Comparator<ApplicationPermissionValue>,
        Serializable {
            private static final long serialVersionUID = 1L;

            ApplicationPermissionValueComparator() {
            }

            @Override
            public int compare(ApplicationPermissionValue o1, ApplicationPermissionValue o2) {
                return o1.compareTo(o2);
            }
        }
    }
}

