/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.secman.applib.permission.dom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Provider;
import lombok.NonNull;
import org.apache.causeway.applib.query.Query;
import org.apache.causeway.applib.services.appfeat.ApplicationFeature;
import org.apache.causeway.applib.services.appfeat.ApplicationFeatureId;
import org.apache.causeway.applib.services.appfeat.ApplicationFeatureRepository;
import org.apache.causeway.applib.services.appfeat.ApplicationFeatureSort;
import org.apache.causeway.applib.services.factory.FactoryService;
import org.apache.causeway.applib.services.message.MessageService;
import org.apache.causeway.applib.services.queryresultscache.QueryResultsCache;
import org.apache.causeway.applib.services.repository.RepositoryService;
import org.apache.causeway.applib.services.user.RoleMemento;
import org.apache.causeway.applib.services.user.UserMemento;
import org.apache.causeway.commons.internal.base._Casts;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.commons.internal.collections._Lists;
import org.apache.causeway.commons.internal.collections._Multimaps;
import org.apache.causeway.commons.internal.collections._Sets;
import org.apache.causeway.extensions.secman.applib.permission.dom.ApplicationPermission;
import org.apache.causeway.extensions.secman.applib.permission.dom.ApplicationPermissionMode;
import org.apache.causeway.extensions.secman.applib.permission.dom.ApplicationPermissionRepository;
import org.apache.causeway.extensions.secman.applib.permission.dom.ApplicationPermissionRule;
import org.apache.causeway.extensions.secman.applib.permission.dom.ApplicationPermissionValue;
import org.apache.causeway.extensions.secman.applib.role.dom.ApplicationRole;
import org.apache.causeway.extensions.secman.applib.user.dom.ApplicationUser;

public abstract class ApplicationPermissionRepositoryAbstract<P extends ApplicationPermission>
implements ApplicationPermissionRepository {
    @Inject
    private RepositoryService repository;
    @Inject
    private ApplicationFeatureRepository featureRepository;
    @Inject
    private FactoryService factory;
    @Inject
    private MessageService messages;
    @Inject
    private Provider<QueryResultsCache> queryResultsCacheProvider;
    private final Class<P> applicationPermissionClass;

    protected ApplicationPermissionRepositoryAbstract(Class<P> applicationPermissionClass) {
        this.applicationPermissionClass = applicationPermissionClass;
    }

    @Override
    public ApplicationPermission newApplicationPermission() {
        return (ApplicationPermission)this.factory.detachedEntity(this.applicationPermissionClass);
    }

    public List<ApplicationPermission> findByRoleCached(@NonNull ApplicationRole role) {
        if (role == null) {
            throw new NullPointerException("role is marked non-null but is null");
        }
        return (List)((QueryResultsCache)this.queryResultsCacheProvider.get()).execute(this::findByRole, ApplicationPermissionRepositoryAbstract.class, "findByRoleCached", (Object)role);
    }

    @Override
    public List<ApplicationPermission> findByRole(@NonNull ApplicationRole role) {
        if (role == null) {
            throw new NullPointerException("role is marked non-null but is null");
        }
        return (List)_Casts.uncheckedCast((Object)this.repository.allMatches((Query)Query.named(this.applicationPermissionClass, (String)"causeway.ext.secman.ApplicationPermission.findByRole").withParameter("role", (Object)role)));
    }

    public List<ApplicationPermission> findByUserCached(@NonNull ApplicationUser user) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        return (List)((QueryResultsCache)this.queryResultsCacheProvider.get()).execute(this::findByUser, ApplicationPermissionRepositoryAbstract.class, "findByUserCached", (Object)user);
    }

    @Override
    public List<ApplicationPermission> findByUser(@NonNull ApplicationUser user) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        return this.findByUser(user.getUsername());
    }

    @Override
    public List<ApplicationPermission> findByUserMemento(@NonNull UserMemento userMemento) {
        if (userMemento == null) {
            throw new NullPointerException("userMemento is marked non-null but is null");
        }
        List<String> roleNames = userMemento.getRoles().stream().map(RoleMemento::getName).collect(Collectors.toList());
        return this.findByRoleNames(roleNames);
    }

    @Override
    public List<ApplicationPermission> findByRoleNames(@NonNull List<String> roleNames) {
        if (roleNames == null) {
            throw new NullPointerException("roleNames is marked non-null but is null");
        }
        return (List)_Casts.uncheckedCast((Object)this.repository.allMatches((Query)Query.named(this.applicationPermissionClass, (String)"causeway.ext.secman.ApplicationPermission.findByRoleNames").withParameter("roleNames", roleNames)));
    }

    private List<ApplicationPermission> findByUser(String username) {
        return (List)_Casts.uncheckedCast((Object)this.repository.allMatches((Query)Query.named(this.applicationPermissionClass, (String)"causeway.ext.secman.ApplicationPermission.findByUser").withParameter("username", (Object)username)));
    }

    @Override
    public Optional<ApplicationPermission> findByUserAndPermissionValue(String username, ApplicationPermissionValue permissionValue) {
        _Multimaps.ListMultimap permissions = (_Multimaps.ListMultimap)((QueryResultsCache)this.queryResultsCacheProvider.get()).execute(this::permissionsByPermissionValue, ApplicationPermissionRepositoryAbstract.class, "findByUserAndPermissionValue", (Object)username);
        List applicationPermissions = (List)permissions.get((Object)permissionValue);
        return applicationPermissions != null && !applicationPermissions.isEmpty() ? Optional.of((ApplicationPermission)applicationPermissions.get(0)) : Optional.empty();
    }

    private _Multimaps.ListMultimap<ApplicationPermissionValue, ApplicationPermission> permissionsByPermissionValue(String username) {
        _Multimaps.ListMultimap permissionsByPermissionValue = _Multimaps.newListMultimap();
        List<ApplicationPermission> permissions = this.findByUser(username);
        _NullSafe.stream(permissions).forEach(permission -> {
            ApplicationPermissionValue newPermissionValue = ApplicationPermission.Functions.AS_VALUE.apply((ApplicationPermission)permission);
            permissionsByPermissionValue.putElement((Object)newPermissionValue, permission);
        });
        return permissionsByPermissionValue;
    }

    @Override
    public Collection<ApplicationPermission> findByRoleAndRuleAndFeatureTypeCached(ApplicationRole role, ApplicationPermissionRule rule, ApplicationFeatureSort type) {
        return (Collection)((QueryResultsCache)this.queryResultsCacheProvider.get()).execute(this::findByRoleAndRuleAndFeatureType, ApplicationPermissionRepositoryAbstract.class, "findByRoleAndRuleAndFeatureTypeCached", (Object)role, (Object)rule, (Object)type);
    }

    public Collection<ApplicationPermission> findByRoleAndRuleAndFeatureType(ApplicationRole role, ApplicationPermissionRule rule, ApplicationFeatureSort featureSort) {
        return (Collection)this.repository.allMatches((Query)Query.named(this.applicationPermissionClass, (String)"causeway.ext.secman.ApplicationPermission.findByRoleAndRuleAndFeature").withParameter("role", (Object)role).withParameter("rule", (Object)rule).withParameter("featureSort", (Object)featureSort)).stream().collect(_Sets.toUnmodifiableSorted());
    }

    public Optional<ApplicationPermission> findByRoleAndRuleAndFeatureCached(ApplicationRole role, ApplicationPermissionRule rule, ApplicationFeatureSort featureSort, String featureFqn) {
        return (Optional)((QueryResultsCache)this.queryResultsCacheProvider.get()).execute(this::findByRoleAndRuleAndFeature, ApplicationPermissionRepositoryAbstract.class, "findByRoleAndRuleAndFeatureCached", (Object)role, (Object)rule, (Object)featureSort, (Object)featureFqn);
    }

    @Override
    public Optional<ApplicationPermission> findByRoleAndRuleAndFeature(ApplicationRole role, ApplicationPermissionRule rule, ApplicationFeatureSort featureSort, String featureFqn) {
        return (Optional)_Casts.uncheckedCast((Object)this.repository.uniqueMatch((Query)Query.named(this.applicationPermissionClass, (String)"causeway.ext.secman.ApplicationPermission.findByRoleAndRuleAndFeatureAndFqn").withParameter("role", (Object)role).withParameter("rule", (Object)rule).withParameter("featureSort", (Object)featureSort).withParameter("featureFqn", (Object)featureFqn)));
    }

    @Override
    public Collection<ApplicationPermission> findByFeatureCached(ApplicationFeatureId featureId) {
        return (Collection)((QueryResultsCache)this.queryResultsCacheProvider.get()).execute(this::findByFeature, ApplicationPermissionRepositoryAbstract.class, "findByFeatureCached", (Object)featureId);
    }

    public Collection<ApplicationPermission> findByFeature(ApplicationFeatureId featureId) {
        return (Collection)this.repository.allMatches((Query)Query.named(this.applicationPermissionClass, (String)"causeway.ext.secman.ApplicationPermission.findByFeature").withParameter("featureSort", (Object)featureId.getSort()).withParameter("featureFqn", (Object)featureId.getFullyQualifiedName())).stream().collect(_Sets.toUnmodifiableSorted());
    }

    @Override
    public ApplicationPermission newPermission(ApplicationRole genericRole, ApplicationPermissionRule rule, ApplicationPermissionMode mode, ApplicationFeatureSort featureSort, String featureFqn) {
        ApplicationRole role = (ApplicationRole)_Casts.uncheckedCast((Object)genericRole);
        ApplicationFeatureId featureId = ApplicationFeatureId.newFeature((ApplicationFeatureSort)featureSort, (String)featureFqn);
        ApplicationFeature feature = this.featureRepository.findFeature(featureId);
        if (feature == null) {
            this.messages.warnUser("No such " + featureSort.name().toLowerCase() + ": " + featureFqn);
            return null;
        }
        return this.newPermissionNoCheck(role, rule, mode, featureSort, featureFqn);
    }

    @Override
    public ApplicationPermission newPermissionNoCheck(ApplicationRole role, ApplicationPermissionRule rule, ApplicationPermissionMode mode, ApplicationFeatureSort featureSort, String featureFqn) {
        ApplicationPermission permission = this.findByRoleAndRuleAndFeature(role, rule, featureSort, featureFqn).orElse(null);
        if (permission != null) {
            return permission;
        }
        permission = this.newApplicationPermission();
        permission.setRole(role);
        permission.setRule(rule);
        permission.setMode(mode);
        permission.setFeatureSort(featureSort);
        permission.setFeatureFqn(featureFqn);
        this.repository.persist((Object)permission);
        return permission;
    }

    @Override
    public ApplicationPermission newPermission(ApplicationRole genericRole, ApplicationPermissionRule rule, ApplicationPermissionMode mode, String featurePackage, String featureClassName, String featureMemberName) {
        ApplicationFeatureId featureId = ApplicationFeatureId.newFeature((String)featurePackage, (String)featureClassName, (String)featureMemberName);
        return this.newPermission(genericRole, rule, mode, featureId);
    }

    @Override
    public ApplicationPermission newPermission(ApplicationRole genericRole, ApplicationPermissionRule rule, ApplicationPermissionMode mode, ApplicationFeatureId featureId) {
        ApplicationRole role = (ApplicationRole)_Casts.uncheckedCast((Object)genericRole);
        ApplicationFeatureSort featureSort = featureId.getSort();
        String featureFqn = featureId.getFullyQualifiedName();
        ApplicationFeature feature = this.featureRepository.findFeature(featureId);
        if (feature == null) {
            this.messages.warnUser("No such " + featureSort.name().toLowerCase() + ": " + featureFqn);
            return null;
        }
        ApplicationPermission permission = (ApplicationPermission)this.factory.detachedEntity(this.applicationPermissionClass);
        permission.setRole(role);
        permission.setRule(rule);
        permission.setMode(mode);
        permission.setFeatureSort(featureSort);
        permission.setFeatureFqn(featureFqn);
        this.repository.persist((Object)permission);
        return permission;
    }

    @Override
    public Collection<ApplicationPermission> allPermissions() {
        return (Collection)this.repository.allInstances(this.applicationPermissionClass).stream().collect(_Sets.toUnmodifiableSorted());
    }

    @Override
    public Collection<ApplicationPermission> findOrphaned() {
        Set featureNamesKnownToTheMetamodel = this.featureRepository.getFeatureIdentifiersByName().keySet();
        ArrayList orphaned = _Lists.newArrayList();
        for (ApplicationPermission permission : this.allPermissions()) {
            ApplicationFeatureId featId = permission.asFeatureId().orElse(null);
            if (featId == null) {
                orphaned.add(permission);
                continue;
            }
            if (featureNamesKnownToTheMetamodel.contains(featId.getFullyQualifiedName())) continue;
            orphaned.add(permission);
        }
        return orphaned;
    }
}

