/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.secman.applib.permission.dom;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.causeway.applib.annotation.DomainObject;
import org.apache.causeway.applib.annotation.DomainObjectLayout;
import org.apache.causeway.applib.annotation.Editing;
import org.apache.causeway.applib.annotation.ObjectSupport;
import org.apache.causeway.applib.annotation.Optionality;
import org.apache.causeway.applib.annotation.Parameter;
import org.apache.causeway.applib.annotation.Programmatic;
import org.apache.causeway.applib.annotation.Property;
import org.apache.causeway.applib.annotation.PropertyLayout;
import org.apache.causeway.applib.annotation.Where;
import org.apache.causeway.applib.services.appfeat.ApplicationFeature;
import org.apache.causeway.applib.services.appfeat.ApplicationFeatureId;
import org.apache.causeway.applib.services.appfeat.ApplicationFeatureRepository;
import org.apache.causeway.applib.services.appfeat.ApplicationFeatureSort;
import org.apache.causeway.applib.services.appfeat.ApplicationMemberSort;
import org.apache.causeway.applib.util.ObjectContracts;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.apache.causeway.extensions.secman.applib.CausewayModuleExtSecmanApplib;
import org.apache.causeway.extensions.secman.applib.permission.dom.ApplicationPermissionMode;
import org.apache.causeway.extensions.secman.applib.permission.dom.ApplicationPermissionRule;
import org.apache.causeway.extensions.secman.applib.permission.dom.ApplicationPermissionValue;
import org.apache.causeway.extensions.secman.applib.role.dom.ApplicationRole;

@Named(value="causeway.ext.secman.ApplicationPermission")
@DomainObject
@DomainObjectLayout(titleUiEvent=TitleUiEvent.class, iconUiEvent=IconUiEvent.class, cssClassUiEvent=CssClassUiEvent.class, layoutUiEvent=LayoutUiEvent.class)
public abstract class ApplicationPermission
implements Comparable<ApplicationPermission> {
    public static final String LOGICAL_TYPE_NAME = "causeway.ext.secman.ApplicationPermission";
    public static final String SCHEMA = "causewayExtSecman";
    public static final String TABLE = "ApplicationPermission";
    @Inject
    transient ApplicationFeatureRepository featureRepository;
    private static final ObjectContracts.ObjectContract<ApplicationPermission> contract = ObjectContracts.contract(ApplicationPermission.class).thenUse("role", ApplicationPermission::getRole).thenUse("featureSort", ApplicationPermission::getFeatureSort).thenUse("featureFqn", ApplicationPermission::getFeatureFqn).thenUse("mode", ApplicationPermission::getMode);

    @ObjectSupport
    public String title() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getRole().getName()).append(":").append(" ").append(this.getRule().toString()).append(" ").append(this.getMode().toString()).append(" of ");
        this.asFeatureId().ifPresent(featureId -> {
            switch (featureId.getSort()) {
                case NAMESPACE: {
                    buf.append(this.getFeatureFqn());
                    break;
                }
                case TYPE: {
                    if (this.getFeatureFqn().length() < 30) {
                        buf.append(this.getFeatureFqn());
                        break;
                    }
                    buf.append(featureId.getTypeSimpleName());
                    break;
                }
                case MEMBER: {
                    buf.append(featureId.getTypeSimpleName()).append("#").append(featureId.getLogicalMemberName());
                }
            }
        });
        return buf.toString();
    }

    @Role
    public abstract ApplicationRole getRole();

    public abstract void setRole(ApplicationRole var1);

    @Rule
    public abstract ApplicationPermissionRule getRule();

    public abstract void setRule(ApplicationPermissionRule var1);

    @Mode
    public abstract ApplicationPermissionMode getMode();

    public abstract void setMode(ApplicationPermissionMode var1);

    @Sort
    public String getSort() {
        ApplicationFeatureSort e = this.getFeatureSort() != ApplicationFeatureSort.MEMBER ? this.getFeatureSort() : (Enum)this.getMemberSort().orElse(null);
        return e != null ? e.name() : null;
    }

    @Programmatic
    public abstract ApplicationFeatureSort getFeatureSort();

    public abstract void setFeatureSort(ApplicationFeatureSort var1);

    @FeatureFqn
    public abstract String getFeatureFqn();

    public abstract void setFeatureFqn(String var1);

    @Programmatic
    public ApplicationFeature findFeature(ApplicationFeatureId featureId) {
        return this.featureRepository.findFeature(featureId);
    }

    @Programmatic
    private Optional<ApplicationMemberSort> getMemberSort() {
        return this.getFeature().flatMap(ApplicationFeature::getMemberSort);
    }

    @Programmatic
    private Optional<ApplicationFeature> getFeature() {
        return this.asFeatureId().map(this::findFeature);
    }

    @Programmatic
    Optional<ApplicationFeatureId> asFeatureId() {
        return Optional.ofNullable(this.getFeatureSort()).map(featureSort -> ApplicationFeatureId.newFeature((ApplicationFeatureSort)featureSort, (String)this.getFeatureFqn()));
    }

    @Override
    public int compareTo(ApplicationPermission other) {
        return contract.compare((Object)this, (Object)other);
    }

    public boolean equals(Object other) {
        return contract.equals((Object)this, other);
    }

    public int hashCode() {
        return contract.hashCode((Object)this);
    }

    public String toString() {
        return contract.toString((Object)this);
    }

    public static final class Functions {
        public static final Function<ApplicationPermission, ApplicationPermissionValue> AS_VALUE = input -> new ApplicationPermissionValue(input.asFeatureId().orElseThrow(_Exceptions::noSuchElement), input.getRule(), input.getMode());

        private Functions() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }

    public static class DefaultComparator
    implements Comparator<ApplicationPermission> {
        @Override
        public int compare(ApplicationPermission o1, ApplicationPermission o2) {
            return Objects.compare(o1, o2, Comparator.naturalOrder());
        }
    }

    @Property(domainEvent=DomainEvent.class, editing=Editing.DISABLED)
    @PropertyLayout(fieldSetId="identity", sequence="2")
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface FeatureFqn {
        public static final boolean NULLABLE = false;
        public static final String ALLOWS_NULL = "false";

        public static class DomainEvent
        extends PropertyDomainEvent<String> {
        }
    }

    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface FeatureSort {
        public static final int TYPICAL_LENGTH = 7;
        public static final boolean NULLABLE = false;
        public static final String ALLOWS_NULL = "false";
    }

    @Property(domainEvent=DomainEvent.class, editing=Editing.DISABLED)
    @PropertyLayout(fieldSetId="identity", sequence="3", typicalLength=7)
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Sort {
        public static final int TYPICAL_LENGTH = 7;

        public static class DomainEvent
        extends PropertyDomainEvent<String> {
        }
    }

    @Property(domainEvent=DomainEvent.class, editing=Editing.DISABLED, optionality=Optionality.MANDATORY)
    @PropertyLayout(fieldSetId="mode", sequence="1")
    @Parameter(optionality=Optionality.MANDATORY)
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Mode {
        public static final boolean NULLABLE = false;
        public static final String ALLOWS_NULL = "false";

        public static class DomainEvent
        extends PropertyDomainEvent<ApplicationPermissionMode> {
        }
    }

    @Property(domainEvent=DomainEvent.class, editing=Editing.DISABLED, optionality=Optionality.MANDATORY)
    @PropertyLayout(fieldSetId="rule", sequence="1")
    @Parameter(optionality=Optionality.MANDATORY)
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Rule {
        public static final boolean NULLABLE = false;
        public static final String ALLOWS_NULL = "false";

        public static class DomainEvent
        extends PropertyDomainEvent<ApplicationPermissionRule> {
        }
    }

    @Property(domainEvent=DomainEvent.class, editing=Editing.DISABLED, optionality=Optionality.MANDATORY)
    @PropertyLayout(fieldSetId="identity", hidden=Where.REFERENCES_PARENT, sequence="1")
    @Parameter(optionality=Optionality.MANDATORY)
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Role {
        public static final String NAME = "roleId";
        public static final boolean NULLABLE = false;
        public static final String ALLOWS_NULL = "false";

        public static class DomainEvent
        extends PropertyDomainEvent<ApplicationRole> {
        }
    }

    public static abstract class CollectionDomainEvent<T>
    extends CausewayModuleExtSecmanApplib.CollectionDomainEvent<ApplicationPermission, T> {
    }

    public static abstract class PropertyDomainEvent<T>
    extends CausewayModuleExtSecmanApplib.PropertyDomainEvent<ApplicationPermission, T> {
    }

    public static class LayoutUiEvent
    extends CausewayModuleExtSecmanApplib.LayoutUiEvent<ApplicationPermission> {
    }

    public static class CssClassUiEvent
    extends CausewayModuleExtSecmanApplib.CssClassUiEvent<ApplicationPermission> {
    }

    public static class IconUiEvent
    extends CausewayModuleExtSecmanApplib.IconUiEvent<ApplicationPermission> {
    }

    public static class TitleUiEvent
    extends CausewayModuleExtSecmanApplib.TitleUiEvent<ApplicationPermission> {
    }

    public static final class Nq {
        public static final String FIND_BY_FEATURE = "causeway.ext.secman.ApplicationPermission.findByFeature";
        public static final String FIND_BY_ROLE = "causeway.ext.secman.ApplicationPermission.findByRole";
        public static final String FIND_BY_ROLE_RULE_FEATURE = "causeway.ext.secman.ApplicationPermission.findByRoleAndRuleAndFeature";
        public static final String FIND_BY_ROLE_RULE_FEATURE_FQN = "causeway.ext.secman.ApplicationPermission.findByRoleAndRuleAndFeatureAndFqn";
        public static final String FIND_BY_USER = "causeway.ext.secman.ApplicationPermission.findByUser";
        public static final String FIND_BY_ROLE_NAMES = "causeway.ext.secman.ApplicationPermission.findByRoleNames";

        private Nq() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }
}

