/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.secman.applib.permission.app.mixins;

import java.util.Collection;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.causeway.applib.annotation.Action;
import org.apache.causeway.applib.annotation.ActionLayout;
import org.apache.causeway.applib.annotation.MemberSupport;
import org.apache.causeway.applib.annotation.Optionality;
import org.apache.causeway.applib.annotation.Parameter;
import org.apache.causeway.applib.annotation.SemanticsOf;
import org.apache.causeway.applib.services.appfeat.ApplicationFeature;
import org.apache.causeway.applib.services.appfeat.ApplicationFeatureId;
import org.apache.causeway.applib.services.appfeat.ApplicationFeatureRepository;
import org.apache.causeway.applib.services.appfeat.ApplicationFeatureSort;
import org.apache.causeway.extensions.secman.applib.CausewayModuleExtSecmanApplib;
import org.apache.causeway.extensions.secman.applib.permission.app.ApplicationOrphanedPermissionManager;
import org.apache.causeway.extensions.secman.applib.permission.dom.ApplicationPermission;

@Action(choicesFrom="orphanedPermissions", domainEvent=DomainEvent.class, semantics=SemanticsOf.IDEMPOTENT_ARE_YOU_SURE)
@ActionLayout(associateWith="orphanedPermissions", describedAs="For the selected permissions, relocates to the specified namespace")
public class ApplicationOrphanedPermissionManager_relocateSelected {
    @Inject
    private ApplicationFeatureRepository featureRepository;
    private final ApplicationOrphanedPermissionManager target;

    @MemberSupport
    public ApplicationOrphanedPermissionManager act(Collection<ApplicationPermission> permissions, @Parameter(optionality=Optionality.MANDATORY) String targetNamespace) {
        permissions.forEach(perm -> this.relocate((ApplicationPermission)perm, targetNamespace));
        return this.target;
    }

    @MemberSupport
    public Collection<String> choices1Act() {
        return this.featureRepository.allNamespaces().stream().map(ApplicationFeature::getFullyQualifiedName).collect(Collectors.toCollection(TreeSet::new));
    }

    private void relocate(ApplicationPermission permission, String targetNamespace) {
        ApplicationFeatureId appFeatureId = ApplicationFeatureId.newFeature((ApplicationFeatureSort)permission.getFeatureSort(), (String)permission.getFeatureFqn());
        String relocatedFqn = appFeatureId.withNamespace(targetNamespace).getFullyQualifiedName();
        permission.setFeatureFqn(relocatedFqn);
    }

    public ApplicationOrphanedPermissionManager_relocateSelected(ApplicationOrphanedPermissionManager target) {
        this.target = target;
    }

    public static class DomainEvent
    extends CausewayModuleExtSecmanApplib.ActionDomainEvent<ApplicationOrphanedPermissionManager_relocateSelected> {
    }
}

