/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.secman.applib.feature.api;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.causeway.applib.ViewModel;
import org.apache.causeway.applib.annotation.DomainObject;
import org.apache.causeway.applib.annotation.MinLength;
import org.apache.causeway.applib.annotation.Nature;
import org.apache.causeway.applib.annotation.ObjectSupport;
import org.apache.causeway.applib.annotation.Property;
import org.apache.causeway.applib.services.appfeat.ApplicationFeatureId;
import org.apache.causeway.applib.services.appfeat.ApplicationFeatureRepository;
import org.apache.causeway.commons.internal.functions._Predicates;
import org.springframework.stereotype.Service;

@Service
public class ApplicationFeatureChoices {
    final ApplicationFeatureRepository featureRepository;
    public static final String DESCRIBED_AS = "To refine the search by feature-sort (namespace, type, member), use one of n: t: m:";

    public Collection<AppFeat> autoCompleteFeature(@MinLength(value=3) String search) {
        String searchTerm;
        Predicate searchRefine;
        if (search.startsWith("n:")) {
            searchRefine = ApplicationFeatureChoices::isNamespace;
            searchTerm = search.substring(2).trim();
        } else if (search.startsWith("t:")) {
            searchRefine = ApplicationFeatureChoices::isType;
            searchTerm = search.substring(2).trim();
        } else if (search.startsWith("m:")) {
            searchRefine = ApplicationFeatureChoices::isMember;
            searchTerm = search.substring(2).trim();
        } else {
            searchRefine = _Predicates.alwaysTrue();
            searchTerm = search.trim();
        }
        Map idsByName = this.featureRepository.getFeatureIdentifiersByName();
        return idsByName.entrySet().stream().filter(entry -> searchRefine.test((ApplicationFeatureId)entry.getValue())).filter(entry -> ((String)entry.getKey()).contains(searchTerm)).map(Map.Entry::getValue).map(AppFeat::new).collect(Collectors.toCollection(TreeSet::new));
    }

    private static boolean isNamespace(ApplicationFeatureId featureId) {
        return featureId.getSort().isNamespace();
    }

    private static boolean isType(ApplicationFeatureId featureId) {
        return featureId.getSort().isType();
    }

    private static boolean isMember(ApplicationFeatureId featureId) {
        return featureId.getSort().isMember();
    }

    @Inject
    public ApplicationFeatureChoices(ApplicationFeatureRepository featureRepository) {
        this.featureRepository = featureRepository;
    }

    @Named(value="causeway.ext.secman.AppFeat")
    @DomainObject(nature=Nature.VIEW_MODEL)
    public static class AppFeat
    implements Comparable<AppFeat>,
    ViewModel {
        public static final String LOGICAL_TYPE_NAME = "causeway.ext.secman.AppFeat";
        @Property
        private ApplicationFeatureId featureId;

        @ObjectSupport
        public String title() {
            return this.toString();
        }

        @Override
        public int compareTo(AppFeat o) {
            ApplicationFeatureId otherId;
            ApplicationFeatureId thisId = this.getFeatureId();
            ApplicationFeatureId applicationFeatureId = otherId = o != null ? o.getFeatureId() : null;
            if (Objects.equals(thisId, otherId)) {
                return 0;
            }
            if (thisId == null) {
                return -1;
            }
            if (otherId == null) {
                return 1;
            }
            return this.getFeatureId().compareTo(o.getFeatureId());
        }

        public String toString() {
            return this.featureId != null ? this.featureId.getSort().name() + ": " + this.featureId.getFullyQualifiedName() : "<no id>";
        }

        @Inject
        public AppFeat(String memento) {
            this(ApplicationFeatureId.parseEncoded((String)memento));
        }

        public String viewModelMemento() {
            return this.featureId != null ? this.featureId.asEncodedString() : "<no id>";
        }

        public AppFeat(ApplicationFeatureId featureId) {
            this.featureId = featureId;
        }

        public AppFeat() {
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AppFeat)) {
                return false;
            }
            AppFeat other = (AppFeat)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ApplicationFeatureId this$featureId = this.getFeatureId();
            ApplicationFeatureId other$featureId = other.getFeatureId();
            return !(this$featureId == null ? other$featureId != null : !this$featureId.equals(other$featureId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AppFeat;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ApplicationFeatureId $featureId = this.getFeatureId();
            result = result * 59 + ($featureId == null ? 43 : $featureId.hashCode());
            return result;
        }

        public ApplicationFeatureId getFeatureId() {
            return this.featureId;
        }
    }
}

