/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.secman.applib.user.dom.mixins.perms;

import java.util.List;
import org.apache.causeway.applib.Identifier;
import org.apache.causeway.applib.id.LogicalType;
import org.apache.causeway.applib.services.appfeat.ApplicationFeatureId;
import org.apache.causeway.applib.services.factory.FactoryService;
import org.apache.causeway.core.metamodel._testing.MetaModelContext_forTesting;
import org.apache.causeway.extensions.secman.applib.permission.dom.ApplicationPermissionMode;
import org.apache.causeway.extensions.secman.applib.permission.dom.ApplicationPermissionRule;
import org.apache.causeway.extensions.secman.applib.permission.dom.ApplicationPermissionValue;
import org.apache.causeway.extensions.secman.applib.permission.dom.ApplicationPermissionValueSet;
import org.apache.causeway.extensions.secman.applib.permission.spi.PermissionsEvaluationService;
import org.apache.causeway.extensions.secman.applib.user.dom.ApplicationUser;
import org.apache.causeway.extensions.secman.applib.user.dom.mixins.perms.UserPermissionViewModel;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;

class UserPermissionViewModelTest {
    UserPermissionViewModelTest() {
    }

    @ParameterizedTest
    @ValueSource(strings={"sven", "!@$5:", ""})
    void roundtrip(String username) {
        ApplicationFeatureId featureId = ApplicationFeatureId.fromIdentifier((Identifier)Identifier.classIdentifier((LogicalType)LogicalType.fqcn(this.getClass())));
        PermissionsEvaluationService permissionsEvaluationService = (PermissionsEvaluationService)Mockito.mock(PermissionsEvaluationService.class);
        List<ApplicationPermissionValue> permissions = List.of(new ApplicationPermissionValue(featureId, ApplicationPermissionRule.ALLOW, ApplicationPermissionMode.CHANGING));
        ApplicationUser user = (ApplicationUser)Mockito.mock(ApplicationUser.class);
        Mockito.when((Object)user.getUsername()).thenReturn((Object)username);
        Mockito.when((Object)user.getPermissionSet()).thenReturn((Object)new ApplicationPermissionValueSet(permissions, permissionsEvaluationService));
        FactoryService factoryService = MetaModelContext_forTesting.buildDefault().getFactoryService();
        UserPermissionViewModel vm = (UserPermissionViewModel)UserPermissionViewModel.asViewModel((ApplicationUser)user, (FactoryService)factoryService).apply(featureId);
        String memento = vm.viewModelMemento();
        UserPermissionViewModel vmAfterRoundtrip = new UserPermissionViewModel(memento);
        Assertions.assertEquals((Object)username, (Object)vmAfterRoundtrip.getUsername());
    }
}

