/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.secman.applib;

import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.apache.causeway.applib.services.appfeat.ApplicationFeatureId;
import org.apache.causeway.applib.value.Password;
import org.apache.causeway.extensions.secman.applib.permission.dom.ApplicationPermission;
import org.apache.causeway.extensions.secman.applib.permission.dom.ApplicationPermissionMode;
import org.apache.causeway.extensions.secman.applib.permission.dom.ApplicationPermissionRepository;
import org.apache.causeway.extensions.secman.applib.permission.dom.ApplicationPermissionRule;
import org.apache.causeway.extensions.secman.applib.role.dom.ApplicationRole;
import org.apache.causeway.extensions.secman.applib.role.dom.ApplicationRoleRepository;
import org.apache.causeway.extensions.secman.applib.user.dom.ApplicationUser;
import org.apache.causeway.extensions.secman.applib.user.dom.ApplicationUserRepository;
import org.apache.causeway.extensions.secman.applib.user.dom.ApplicationUserStatus;
import org.apache.causeway.testing.integtestsupport.applib.CausewayIntegrationTestAbstract;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class ApplicationPermissionRepositoryIntegTestAbstract
extends CausewayIntegrationTestAbstract {
    protected ApplicationUser maryUser;
    protected ApplicationUser mungoUser;
    protected ApplicationUser midgeUser;
    protected ApplicationRole girlRole;
    protected ApplicationRole dogRole;
    protected ApplicationRole mouseRole;
    protected ApplicationRole littleRole;
    protected ApplicationRole flatDwellerRole;
    protected ApplicationPermission rideLiftForGirlRolePerm;
    protected ApplicationPermission rideLiftForDogRolePerm;
    protected ApplicationPermission rideLiftForMouseRolePerm;
    protected ApplicationPermission liftButtonForGirlRolePerm;
    protected ApplicationPermission chaseCatsForDogRolePerm;
    protected ApplicationPermission eatCheeseForMouseRolePerm;
    @Inject
    ApplicationPermissionRepository permissionRepository;
    @Inject
    ApplicationRoleRepository roleRepository;
    @Inject
    ApplicationUserRepository userRepository;

    @BeforeEach
    void setUp() {
        this.maryUser = this.userRepository.upsertLocal("mary", Password.of((String)"marypass"), ApplicationUserStatus.UNLOCKED);
        this.mungoUser = this.userRepository.upsertLocal("mungo", Password.of((String)"mungopass"), ApplicationUserStatus.UNLOCKED);
        this.midgeUser = this.userRepository.upsertLocal("midge", Password.of((String)"midgepass"), ApplicationUserStatus.UNLOCKED);
        this.girlRole = this.roleRepository.upsert("girl", "Girl");
        this.dogRole = this.roleRepository.upsert("dog", "Dog");
        this.mouseRole = this.roleRepository.upsert("mouse", "Mouse");
        this.littleRole = this.roleRepository.upsert("little", "Little");
        this.flatDwellerRole = this.roleRepository.upsert("flat-dweller", "Flat Dweller");
        this.roleRepository.addRoleToUser(this.girlRole, this.maryUser);
        this.roleRepository.addRoleToUser(this.littleRole, this.maryUser);
        this.roleRepository.addRoleToUser(this.flatDwellerRole, this.maryUser);
        this.roleRepository.addRoleToUser(this.dogRole, this.mungoUser);
        this.roleRepository.addRoleToUser(this.flatDwellerRole, this.mungoUser);
        this.roleRepository.addRoleToUser(this.mouseRole, this.midgeUser);
        this.roleRepository.addRoleToUser(this.littleRole, this.midgeUser);
        this.roleRepository.addRoleToUser(this.flatDwellerRole, this.midgeUser);
        ApplicationFeatureId rideLiftFeature = ApplicationFeatureId.newType((String)"mmm.RideLiftService");
        this.liftButtonForGirlRolePerm = this.permissionRepository.newPermission(this.girlRole, ApplicationPermissionRule.ALLOW, ApplicationPermissionMode.CHANGING, ApplicationFeatureId.newType((String)"mmm.PressLiftButtonService"));
        this.rideLiftForGirlRolePerm = this.permissionRepository.newPermission(this.girlRole, ApplicationPermissionRule.ALLOW, ApplicationPermissionMode.CHANGING, rideLiftFeature);
        this.rideLiftForDogRolePerm = this.permissionRepository.newPermission(this.dogRole, ApplicationPermissionRule.ALLOW, ApplicationPermissionMode.CHANGING, rideLiftFeature);
        this.chaseCatsForDogRolePerm = this.permissionRepository.newPermission(this.dogRole, ApplicationPermissionRule.ALLOW, ApplicationPermissionMode.CHANGING, ApplicationFeatureId.newType((String)"mmm.ChaseCatsService"));
        this.rideLiftForMouseRolePerm = this.permissionRepository.newPermission(this.mouseRole, ApplicationPermissionRule.ALLOW, ApplicationPermissionMode.CHANGING, rideLiftFeature);
        this.eatCheeseForMouseRolePerm = this.permissionRepository.newPermission(this.mouseRole, ApplicationPermissionRule.ALLOW, ApplicationPermissionMode.CHANGING, ApplicationFeatureId.newType((String)"mmm.EatsCheeseService"));
    }

    @Test
    void end_to_end() {
        List maryPermissions = this.permissionRepository.findByUser(this.maryUser);
        Assertions.assertThat((List)maryPermissions).containsExactlyInAnyOrder((Object[])new ApplicationPermission[]{this.liftButtonForGirlRolePerm, this.rideLiftForGirlRolePerm});
        List adhocPermissions = this.permissionRepository.findByRoleNames(Arrays.asList(this.girlRole.getName(), this.mouseRole.getName()));
        Assertions.assertThat((List)adhocPermissions).containsExactlyInAnyOrder((Object[])new ApplicationPermission[]{this.liftButtonForGirlRolePerm, this.rideLiftForGirlRolePerm, this.rideLiftForMouseRolePerm, this.eatCheeseForMouseRolePerm});
    }
}

