/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.layoutloaders.github.spiimpl;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.apache.causeway.applib.services.queryresultscache.QueryResultsCache;
import org.apache.causeway.commons.internal.resources._Resources;
import org.apache.causeway.core.config.CausewayConfiguration;
import org.apache.causeway.extensions.layoutloaders.github.CausewayModuleExtLayoutLoadersGithub;
import org.apache.causeway.extensions.layoutloaders.github.menu.LayoutLoadersGitHubMenu;
import org.apache.causeway.extensions.layoutloaders.github.spiimpl.LayoutResourceLoaderFromGithub;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.web.client.RestTemplate;

class LayoutResourceLoaderFromGithub_tryLoadLayoutResource_Test {
    LayoutResourceLoaderFromGithub loader;

    LayoutResourceLoaderFromGithub_tryLoadLayoutResource_Test() {
    }

    @BeforeEach
    void preconditions() {
        String apiKey = this.getApiKey();
        Assumptions.assumeThat((String)apiKey).isNotNull();
    }

    @BeforeEach
    void setup() {
        CausewayConfiguration causewayConfiguration = CausewayConfiguration.builder().build();
        causewayConfiguration.getExtensions().getLayoutLoaders().getGithub().setApiKey(this.getApiKey());
        causewayConfiguration.getExtensions().getLayoutLoaders().getGithub().setRepository("apache/causeway-app-simpleapp");
        CausewayModuleExtLayoutLoadersGithub module = new CausewayModuleExtLayoutLoadersGithub();
        RestTemplate restTemplateForSearch = module.restTemplateForGithubSearch(causewayConfiguration);
        RestTemplate restTemplateForContent = module.restTemplateForGithubContent(causewayConfiguration);
        LayoutLoadersGitHubMenu layoutLoaderMenu = new LayoutLoadersGitHubMenu(causewayConfiguration);
        QueryResultsCache queryResultsCache = new QueryResultsCache();
        new LayoutLoadersGitHubMenu.enableDynamicLayoutLoading(layoutLoaderMenu).act();
        Assertions.assertThat((boolean)layoutLoaderMenu.isEnabled()).isTrue();
        this.loader = new LayoutResourceLoaderFromGithub(restTemplateForSearch, restTemplateForContent, causewayConfiguration, layoutLoaderMenu, () -> queryResultsCache);
    }

    @Test
    public void happy_case() {
        Optional layoutResourceIfAny = this.loader.lookupLayoutResource(SimpleObject.class, "SimpleObject.layout.xml");
        Assertions.assertThat((Optional)layoutResourceIfAny).isPresent();
    }

    @Test
    public void sad_case() {
        Optional layoutResourceIfAny = this.loader.lookupLayoutResource(SimpleObject.class, "Unknown.layout.xml");
        Assertions.assertThat((Optional)layoutResourceIfAny).isEmpty();
    }

    private String getApiKey() {
        return _Resources.loadAsString(this.getClass(), (String)"apikey.txt", (Charset)StandardCharsets.UTF_8);
    }

    static class SimpleObject {
        SimpleObject() {
        }
    }
}

