/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.layoutloaders.github.spiimpl;

import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import java.util.HashMap;
import lombok.NonNull;
import org.apache.causeway.applib.services.queryresultscache.QueryResultsCache;
import org.apache.causeway.applib.value.NamedWithMimeType;
import org.apache.causeway.commons.functional.Try;
import org.apache.causeway.core.config.CausewayConfiguration;
import org.apache.causeway.core.metamodel.services.grid.spi.LayoutResource;
import org.apache.causeway.core.metamodel.services.grid.spi.LayoutResourceLoader;
import org.apache.causeway.extensions.layoutloaders.github.menu.LayoutLoadersGitHubMenu;
import org.apache.causeway.extensions.layoutloaders.github.spiimpl.GitHubResponse;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Service
@Named(value="causeway.ext.layoutLoaders.LayoutResourceLoaderFromGithub")
@Priority(value=1073741723)
@Qualifier(value="Github")
public class LayoutResourceLoaderFromGithub
implements LayoutResourceLoader {
    final RestTemplate restTemplateForSearch;
    final RestTemplate restTemplateForContent;
    final CausewayConfiguration causewayConfiguration;
    final LayoutLoadersGitHubMenu layoutLoadersGitHubMenu;
    final Provider<QueryResultsCache> queryResultsCacheProvider;

    @Inject
    public LayoutResourceLoaderFromGithub(@Qualifier(value="GithubSearch") RestTemplate restTemplateForSearch, @Qualifier(value="GithubContent") RestTemplate restTemplateForContent, CausewayConfiguration causewayConfiguration, LayoutLoadersGitHubMenu layoutLoadersGitHubMenu, Provider<QueryResultsCache> queryResultsCacheProvider) {
        this.restTemplateForSearch = restTemplateForSearch;
        this.restTemplateForContent = restTemplateForContent;
        this.causewayConfiguration = causewayConfiguration;
        this.layoutLoadersGitHubMenu = layoutLoadersGitHubMenu;
        this.queryResultsCacheProvider = queryResultsCacheProvider;
    }

    public Try<LayoutResource> tryLoadLayoutResource(@NonNull Class<?> type, @NonNull String candidateResourceName) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (candidateResourceName == null) {
            throw new NullPointerException("candidateResourceName is marked non-null but is null");
        }
        return this.layoutLoadersGitHubMenu.isEnabled() ? (Try)((QueryResultsCache)this.queryResultsCacheProvider.get()).execute(() -> this.tryLoadLayoutResource(candidateResourceName), this.getClass(), "tryLoadLayoutResource", new Object[]{candidateResourceName}) : Try.empty();
    }

    private Try<LayoutResource> tryLoadLayoutResource(String candidateResourceName) {
        return this.search(candidateResourceName).flatMapSuccessAsNullable(path -> this.content(candidateResourceName, (String)path));
    }

    private Try<String> search(@NonNull String candidateResourceName) {
        if (candidateResourceName == null) {
            throw new NullPointerException("candidateResourceName is marked non-null but is null");
        }
        try {
            String repo = this.causewayConfiguration.getExtensions().getLayoutLoaders().getGithub().getRepository();
            HashMap<String, String> searchParams = new HashMap<String, String>();
            searchParams.put("q", String.format("%s+in:path+repo:%s", candidateResourceName, repo));
            ResponseEntity responseEntity = this.restTemplateForSearch.exchange("/search/code?q={q}", HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<GitHubResponse>(){}, searchParams);
            GitHubResponse searchResponse = (GitHubResponse)responseEntity.getBody();
            if (searchResponse.getTotal_count() != 1) {
                return Try.empty();
            }
            return Try.success((Object)searchResponse.getItems().get(0).getPath());
        }
        catch (Exception ex) {
            return Try.failure((Throwable)ex);
        }
    }

    private Try<LayoutResource> content(@NonNull String candidateResourceName, @Nullable String path) {
        if (candidateResourceName == null) {
            throw new NullPointerException("candidateResourceName is marked non-null but is null");
        }
        if (path == null) {
            return Try.empty();
        }
        try {
            ResponseEntity contentResponse = this.restTemplateForContent.exchange("/contents/" + path, HttpMethod.GET, null, String.class, new Object[0]);
            String content = (String)contentResponse.getBody();
            return StringUtils.hasLength((String)content) ? Try.call(() -> new LayoutResource(candidateResourceName, NamedWithMimeType.CommonMimeType.XML, content)) : Try.empty();
        }
        catch (Exception ex) {
            return Try.failure((Throwable)ex);
        }
    }
}

