/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.layoutloaders.github.menu;

import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.apache.causeway.applib.CausewayModuleApplib;
import org.apache.causeway.applib.annotation.Action;
import org.apache.causeway.applib.annotation.ActionLayout;
import org.apache.causeway.applib.annotation.DomainService;
import org.apache.causeway.applib.annotation.DomainServiceLayout;
import org.apache.causeway.applib.annotation.MemberSupport;
import org.apache.causeway.applib.annotation.Publishing;
import org.apache.causeway.applib.annotation.SemanticsOf;
import org.apache.causeway.core.config.CausewayConfiguration;

@Named(value="causeway.ext.layoutLoaders.LayoutLoadersGitHubMenu")
@DomainService
@DomainServiceLayout(menuBar=DomainServiceLayout.MenuBar.TERTIARY)
@Priority(value=0x1FFFFFFF)
public class LayoutLoadersGitHubMenu {
    final CausewayConfiguration causewayConfiguration;
    private boolean enabled;

    boolean isNotConfigured() {
        CausewayConfiguration.Extensions.LayoutLoaders.Github layoutLoadersGitHub = this.causewayConfiguration.getExtensions().getLayoutLoaders().getGithub();
        return layoutLoadersGitHub.getRepository() == null || layoutLoadersGitHub.getApiKey() == null;
    }

    @Inject
    public LayoutLoadersGitHubMenu(CausewayConfiguration causewayConfiguration) {
        this.causewayConfiguration = causewayConfiguration;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Action(commandPublishing=Publishing.DISABLED, domainEvent=ActionDomainEvent.class, executionPublishing=Publishing.DISABLED, semantics=SemanticsOf.IDEMPOTENT)
    @ActionLayout(cssClassFa="fa-solid fa-toggle-off", sequence="100")
    public class disableDynamicLayoutLoading {
        @MemberSupport
        public void act() {
            LayoutLoadersGitHubMenu.this.enabled = false;
        }

        @MemberSupport
        public boolean hideAct() {
            return LayoutLoadersGitHubMenu.this.isNotConfigured();
        }

        @MemberSupport
        public String disableAct() {
            return LayoutLoadersGitHubMenu.this.enabled ? null : "Already disabled";
        }

        public class ActionDomainEvent
        extends org.apache.causeway.extensions.layoutloaders.github.menu.LayoutLoadersGitHubMenu$ActionDomainEvent<disableDynamicLayoutLoading> {
        }
    }

    @Action(commandPublishing=Publishing.DISABLED, domainEvent=ActionDomainEvent.class, executionPublishing=Publishing.DISABLED, semantics=SemanticsOf.IDEMPOTENT)
    @ActionLayout(cssClassFa="fa-solid fa-toggle-on", sequence="100")
    public class enableDynamicLayoutLoading {
        @MemberSupport
        public void act() {
            LayoutLoadersGitHubMenu.this.enabled = true;
        }

        @MemberSupport
        public boolean hideAct() {
            return LayoutLoadersGitHubMenu.this.isNotConfigured();
        }

        @MemberSupport
        public String disableAct() {
            return LayoutLoadersGitHubMenu.this.enabled ? "Already enabled" : null;
        }

        public class ActionDomainEvent
        extends org.apache.causeway.extensions.layoutloaders.github.menu.LayoutLoadersGitHubMenu$ActionDomainEvent<enableDynamicLayoutLoading> {
        }
    }

    public static abstract class ActionDomainEvent<T>
    extends CausewayModuleApplib.ActionDomainEvent<T> {
    }
}

