/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.layoutloaders.github;

import org.apache.causeway.core.config.CausewayConfiguration;
import org.apache.causeway.extensions.layoutloaders.github.menu.LayoutLoadersGitHubMenu;
import org.apache.causeway.extensions.layoutloaders.github.spiimpl.LayoutResourceLoaderFromGithub;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.web.client.RestTemplate;

@Configuration
@Import(value={LayoutLoadersGitHubMenu.class, LayoutResourceLoaderFromGithub.class})
public class CausewayModuleExtLayoutLoadersGithub {
    public static final String NAMESPACE = "causeway.ext.layoutLoaders";

    @Bean(name={"GithubSearch"})
    public RestTemplate restTemplateForGithubSearch(CausewayConfiguration causewayConfiguration) {
        String apiKey = causewayConfiguration.getExtensions().getLayoutLoaders().getGithub().getApiKey();
        return new RestTemplateBuilder(new RestTemplateCustomizer[0]).rootUri("https://api.github.com").additionalInterceptors(new ClientHttpRequestInterceptor[]{(request, body, execution) -> {
            request.getHeaders().add("Authorization", "Bearer " + apiKey);
            request.getHeaders().remove((Object)"Accept");
            request.getHeaders().add("Accept", "application/vnd.github+json");
            request.getHeaders().add("X-GitHub-Api-Version", "2022-11-28");
            return execution.execute(request, body);
        }}).build();
    }

    @Bean(name={"GithubContent"})
    public RestTemplate restTemplateForGithubContent(CausewayConfiguration causewayConfiguration) {
        String apiKey = causewayConfiguration.getExtensions().getLayoutLoaders().getGithub().getApiKey();
        String repo = causewayConfiguration.getExtensions().getLayoutLoaders().getGithub().getRepository();
        return new RestTemplateBuilder(new RestTemplateCustomizer[0]).rootUri(String.format("https://api.github.com/repos/%s", repo)).additionalInterceptors(new ClientHttpRequestInterceptor[]{(request, body, execution) -> {
            request.getHeaders().add("Authorization", "Bearer " + apiKey);
            request.getHeaders().remove((Object)"Accept");
            request.getHeaders().add("Accept", "application/vnd.github.v3.raw");
            request.getHeaders().add("X-GitHub-Api-Version", "2022-11-28");
            return execution.execute(request, body);
        }}).build();
    }
}

