/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.io;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import java.io.OutputStream;
import java.util.Optional;
import java.util.function.UnaryOperator;
import lombok.NonNull;
import org.apache.causeway.commons.functional.Try;
import org.apache.causeway.commons.io.DataSink;
import org.apache.causeway.commons.io.DataSource;
import org.apache.causeway.commons.io.JsonUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.function.ThrowingConsumer;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;

public final class YamlUtils {
    public static <T> Try<T> tryRead(@NonNull Class<T> mappedType, @Nullable String stringUtf8, JsonUtils.JacksonCustomizer ... customizers) {
        if (mappedType == null) {
            throw new NullPointerException("mappedType is marked non-null but is null");
        }
        return YamlUtils.tryRead(mappedType, DataSource.ofStringUtf8(stringUtf8), customizers);
    }

    public static <T> Try<T> tryRead(@NonNull Class<T> mappedType, @NonNull DataSource source, JsonUtils.JacksonCustomizer ... customizers) {
        if (mappedType == null) {
            throw new NullPointerException("mappedType is marked non-null but is null");
        }
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        return source.tryReadAll(is -> Try.call(() -> YamlUtils.createJacksonReader(Optional.empty(), customizers).readValue(is, mappedType)));
    }

    public static <T> Try<T> tryReadCustomized(@NonNull Class<T> mappedType, @Nullable String stringUtf8, @NonNull YamlLoadCustomizer loadCustomizer, JsonUtils.JacksonCustomizer ... customizers) {
        if (mappedType == null) {
            throw new NullPointerException("mappedType is marked non-null but is null");
        }
        if (loadCustomizer == null) {
            throw new NullPointerException("loadCustomizer is marked non-null but is null");
        }
        return YamlUtils.tryReadCustomized(mappedType, DataSource.ofStringUtf8(stringUtf8), loadCustomizer, customizers);
    }

    public static <T> Try<T> tryReadCustomized(@NonNull Class<T> mappedType, @NonNull DataSource source, @NonNull YamlLoadCustomizer loadCustomizer, JsonUtils.JacksonCustomizer ... customizers) {
        if (mappedType == null) {
            throw new NullPointerException("mappedType is marked non-null but is null");
        }
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (loadCustomizer == null) {
            throw new NullPointerException("loadCustomizer is marked non-null but is null");
        }
        return source.tryReadAll(is -> Try.call(() -> YamlUtils.createJacksonReader(Optional.of(loadCustomizer), customizers).readValue(is, mappedType)));
    }

    public static void write(@Nullable Object pojo, @NonNull DataSink sink, JsonUtils.JacksonCustomizer ... customizers) {
        if (sink == null) {
            throw new NullPointerException("sink is marked non-null but is null");
        }
        if (pojo == null) {
            return;
        }
        sink.writeAll((ThrowingConsumer<OutputStream>)((ThrowingConsumer)os -> Try.run(() -> YamlUtils.createJacksonWriter(Optional.empty(), customizers).writeValue(os, pojo))));
    }

    @Nullable
    public static String toStringUtf8(@Nullable Object pojo, JsonUtils.JacksonCustomizer ... customizers) {
        return pojo != null ? YamlUtils.createJacksonWriter(Optional.empty(), customizers).writeValueAsString(pojo) : null;
    }

    public static void writeCustomized(@Nullable Object pojo, @NonNull DataSink sink, @NonNull YamlDumpCustomizer dumpCustomizer, JsonUtils.JacksonCustomizer ... customizers) {
        if (sink == null) {
            throw new NullPointerException("sink is marked non-null but is null");
        }
        if (dumpCustomizer == null) {
            throw new NullPointerException("dumpCustomizer is marked non-null but is null");
        }
        if (pojo == null) {
            return;
        }
        sink.writeAll((ThrowingConsumer<OutputStream>)((ThrowingConsumer)os -> Try.run(() -> YamlUtils.createJacksonWriter(Optional.of(dumpCustomizer), customizers).writeValue(os, pojo))));
    }

    @Nullable
    public static String toStringUtf8Customized(@Nullable Object pojo, @NonNull YamlDumpCustomizer dumpCustomizer, JsonUtils.JacksonCustomizer ... customizers) {
        if (dumpCustomizer == null) {
            throw new NullPointerException("dumpCustomizer is marked non-null but is null");
        }
        return pojo != null ? YamlUtils.createJacksonWriter(Optional.of(dumpCustomizer), customizers).writeValueAsString(pojo) : null;
    }

    public static DumperOptions allowReadOnlyProperties(DumperOptions opts) {
        opts.setAllowReadOnlyProperties(true);
        return opts;
    }

    private static ObjectMapper createJacksonReader(Optional<YamlLoadCustomizer> loadCustomizer, JsonUtils.JacksonCustomizer ... customizers) {
        YAMLFactory yamlFactory = YAMLFactory.builder().loaderOptions(loadCustomizer.map(xva$0 -> YamlUtils.createLoaderOptions(xva$0)).orElseGet(() -> YamlUtils.createLoaderOptions(new YamlLoadCustomizer[0]))).build();
        ObjectMapper mapper = new ObjectMapper((JsonFactory)yamlFactory);
        mapper = JsonUtils.readingJavaTimeSupport(mapper);
        mapper = JsonUtils.readingCanSupport(mapper);
        for (JsonUtils.JacksonCustomizer customizer : customizers) {
            mapper = Optional.ofNullable((ObjectMapper)customizer.apply(mapper)).orElse(mapper);
        }
        return mapper;
    }

    private static ObjectMapper createJacksonWriter(Optional<YamlDumpCustomizer> dumpCustomizer, JsonUtils.JacksonCustomizer ... customizers) {
        YAMLFactory yamlFactory = YAMLFactory.builder().dumperOptions(dumpCustomizer.map(xva$0 -> YamlUtils.createDumperOptions(xva$0)).orElseGet(() -> YamlUtils.createDumperOptions(new YamlDumpCustomizer[0]))).build().disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER);
        ObjectMapper mapper = new ObjectMapper((JsonFactory)yamlFactory);
        mapper = JsonUtils.writingJavaTimeSupport(mapper);
        mapper = JsonUtils.writingCanSupport(mapper);
        for (JsonUtils.JacksonCustomizer customizer : customizers) {
            mapper = Optional.ofNullable((ObjectMapper)customizer.apply(mapper)).orElse(mapper);
        }
        return mapper;
    }

    private static DumperOptions createDumperOptions(YamlDumpCustomizer ... dumpCustomizers) {
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setIndent(2);
        dumperOptions.setLineBreak(DumperOptions.LineBreak.UNIX);
        for (YamlDumpCustomizer customizer : dumpCustomizers) {
            dumperOptions = Optional.ofNullable((DumperOptions)customizer.apply(dumperOptions)).orElse(dumperOptions);
        }
        return dumperOptions;
    }

    private static LoaderOptions createLoaderOptions(YamlLoadCustomizer ... loadCustomizers) {
        LoaderOptions loaderOptions = new LoaderOptions();
        for (YamlLoadCustomizer customizer : loadCustomizers) {
            loaderOptions = Optional.ofNullable((LoaderOptions)customizer.apply(loaderOptions)).orElse(loaderOptions);
        }
        return loaderOptions;
    }

    private YamlUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @FunctionalInterface
    public static interface YamlLoadCustomizer
    extends UnaryOperator<LoaderOptions> {
    }

    @FunctionalInterface
    public static interface YamlDumpCustomizer
    extends UnaryOperator<DumperOptions> {
    }
}

