/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.io;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.jakarta.xmlbind.JakartaXmlBindAnnotationModule;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.UnaryOperator;
import lombok.NonNull;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.functional.Try;
import org.apache.causeway.commons.internal.base._Casts;
import org.apache.causeway.commons.internal.context._Context;
import org.apache.causeway.commons.io.DataSink;
import org.apache.causeway.commons.io.DataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.lang.Nullable;
import org.springframework.util.function.ThrowingConsumer;

public final class JsonUtils {
    private static final Logger log = LogManager.getLogger(JsonUtils.class);

    public static Optional<Class<?>> getPlatformDefaultJsonProviderForJaxb() {
        return Try.call(() -> _Context.loadClass("org.eclipse.persistence.jaxb.rs.MOXyJsonProvider")).ifFailure((ThrowingConsumer<Throwable>)((ThrowingConsumer)cause -> log.warn("This implementation of RestfulClient does require the class 'MOXyJsonProvider' on the class-path. Are you missing a maven dependency?"))).getValue().map(x -> x);
    }

    public static <T> Try<T> tryRead(@NonNull Class<T> mappedType, @Nullable String stringUtf8, JacksonCustomizer ... customizers) {
        if (mappedType == null) {
            throw new NullPointerException("mappedType is marked non-null but is null");
        }
        return JsonUtils.tryRead(mappedType, DataSource.ofStringUtf8(stringUtf8), customizers);
    }

    public static <T> Try<T> tryRead(@NonNull Class<T> mappedType, @NonNull DataSource source, JacksonCustomizer ... customizers) {
        if (mappedType == null) {
            throw new NullPointerException("mappedType is marked non-null but is null");
        }
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        return source.tryReadAll(is -> Try.call(() -> JsonUtils.createJacksonReader(customizers).readValue(is, mappedType)));
    }

    public static <T> Try<List<T>> tryReadAsList(@NonNull Class<T> elementType, @NonNull DataSource source, JacksonCustomizer ... customizers) {
        if (elementType == null) {
            throw new NullPointerException("elementType is marked non-null but is null");
        }
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        return source.tryReadAll(is -> Try.call(() -> {
            ObjectMapper mapper = JsonUtils.createJacksonReader(customizers);
            CollectionType collectionType = mapper.getTypeFactory().constructCollectionType(List.class, elementType);
            return (List)mapper.readValue(is, (JavaType)collectionType);
        }));
    }

    public static void write(@Nullable Object pojo, @NonNull DataSink sink, JacksonCustomizer ... customizers) {
        if (sink == null) {
            throw new NullPointerException("sink is marked non-null but is null");
        }
        if (pojo == null) {
            return;
        }
        sink.writeAll((ThrowingConsumer<OutputStream>)((ThrowingConsumer)os -> Try.run(() -> JsonUtils.createJacksonWriter(customizers).writeValue(os, pojo))));
    }

    @Nullable
    public static String toStringUtf8(@Nullable Object pojo, JacksonCustomizer ... customizers) {
        return pojo != null ? JsonUtils.createJacksonWriter(customizers).writeValueAsString(pojo) : null;
    }

    public static ObjectMapper indentedOutput(ObjectMapper mapper) {
        return mapper.enable(SerializationFeature.INDENT_OUTPUT);
    }

    public static ObjectMapper onlyIncludeNonNull(ObjectMapper mapper) {
        return mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public static ObjectMapper jaxbAnnotationSupport(ObjectMapper mapper) {
        return mapper.registerModule((Module)new JakartaXmlBindAnnotationModule());
    }

    public static ObjectMapper readingJavaTimeSupport(ObjectMapper mapper) {
        mapper.registerModule((Module)new JavaTimeModule());
        mapper.disable(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE);
        return mapper;
    }

    public static ObjectMapper writingJavaTimeSupport(ObjectMapper mapper) {
        mapper.registerModule((Module)new JavaTimeModule());
        mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        return mapper;
    }

    public static ObjectMapper readingCanSupport(ObjectMapper mapper) {
        mapper.registerModule((Module)new SimpleModule().addDeserializer(Can.class, (JsonDeserializer)new CanDeserializer(Object.class)));
        return mapper;
    }

    public static ObjectMapper writingCanSupport(ObjectMapper mapper) {
        mapper.registerModule((Module)new SimpleModule().addSerializer((JsonSerializer)new CanSerializer()));
        return mapper;
    }

    private static ObjectMapper createJacksonReader(JacksonCustomizer ... customizers) {
        ObjectMapper mapper = new ObjectMapper();
        mapper = JsonUtils.readingJavaTimeSupport(mapper);
        mapper = JsonUtils.readingCanSupport(mapper);
        for (JacksonCustomizer customizer : customizers) {
            mapper = Optional.ofNullable((ObjectMapper)customizer.apply(mapper)).orElse(mapper);
        }
        return mapper;
    }

    private static ObjectMapper createJacksonWriter(JacksonCustomizer ... customizers) {
        ObjectMapper mapper = new ObjectMapper();
        mapper = JsonUtils.writingJavaTimeSupport(mapper);
        mapper = JsonUtils.writingCanSupport(mapper);
        for (JacksonCustomizer customizer : customizers) {
            mapper = Optional.ofNullable((ObjectMapper)customizer.apply(mapper)).orElse(mapper);
        }
        return mapper;
    }

    private JsonUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @FunctionalInterface
    public static interface JacksonCustomizer
    extends UnaryOperator<ObjectMapper> {
    }

    static class CanDeserializer
    extends JsonDeserializer<Can<?>>
    implements ContextualDeserializer {
        private Class<?> elementType;

        public CanDeserializer(@NonNull Class<?> elementType) {
            if (elementType == null) {
                throw new NullPointerException("elementType is marked non-null but is null");
            }
            this.elementType = elementType;
        }

        public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty beanProperty) throws JsonMappingException {
            JavaType type = ctxt.getContextualType() != null ? ctxt.getContextualType() : (beanProperty != null ? beanProperty.getMember().getType() : null);
            Class elementType = type != null && type.containedTypeCount() == 1 ? type.containedType(0).getRawClass() : Object.class;
            return new CanDeserializer(elementType);
        }

        public Can<?> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            CollectionType listType = ctxt.getTypeFactory().constructCollectionType(List.class, this.elementType);
            Object list = ctxt.readValue(p, (JavaType)listType);
            return Can.ofCollection((Collection)_Casts.uncheckedCast(list));
        }
    }

    static class CanSerializer
    extends StdSerializer<Can<?>> {
        private static final long serialVersionUID = 1L;

        protected CanSerializer() {
            super(Can.class, false);
        }

        public void serialize(Can<?> value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeObject(value.toList());
        }
    }
}

