/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.memento;

import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import lombok.NonNull;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.apache.causeway.commons.internal.memento._MementoDefault;

public final class _Mementos {
    private static final Memento EMPTY_MEMENTO = new EmptyMemento();

    private _Mementos() {
    }

    public static Memento create(EncoderDecoder codec, SerializingAdapter serializer) {
        return new _MementoDefault(codec, serializer);
    }

    public static Memento parse(EncoderDecoder codec, SerializingAdapter serializer, String input) {
        if (_Strings.isNullOrEmpty(input)) {
            return _Mementos.empty();
        }
        return _MementoDefault.parse(codec, serializer, input);
    }

    public static Memento empty() {
        return EMPTY_MEMENTO;
    }

    public static interface EncoderDecoder {
        public String encode(byte[] var1);

        public byte[] decode(String var1);
    }

    public static interface SerializingAdapter {
        public Serializable write(@NonNull Object var1);

        public <T> T read(@NonNull Class<T> var1, @NonNull Serializable var2);
    }

    public static interface Memento {
        public <T> T get(String var1, Class<T> var2);

        public Memento put(String var1, Object var2);

        public Set<String> keySet();

        public String asString();
    }

    private static final class EmptyMemento
    implements Memento {
        private EmptyMemento() {
        }

        @Override
        public <T> T get(String name, Class<T> cls) {
            return null;
        }

        @Override
        public Memento put(String name, Object value) {
            throw _Exceptions.notImplemented();
        }

        @Override
        public Set<String> keySet() {
            return Collections.emptySet();
        }

        @Override
        public String asString() {
            return "EmptyMemento";
        }
    }
}

