/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.compare;

import java.util.OptionalInt;
import java.util.StringTokenizer;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.commons.internal.primitives._Ints;
import org.springframework.lang.Nullable;

final class _Comparators_SequenceCompare {
    private _Comparators_SequenceCompare() {
    }

    public static int compareNullLast(@Nullable String sequence1, @Nullable String sequence2, String separator) {
        if (_Strings.isEmpty(separator)) {
            throw new IllegalArgumentException("a non empty separator is required");
        }
        if (sequence1 == null && sequence2 == null) {
            return 0;
        }
        if (sequence1 == null && sequence2 != null) {
            return 1;
        }
        if (sequence1 != null && sequence2 == null) {
            return -1;
        }
        StringTokenizer components1 = _Comparators_SequenceCompare.tokenizerFor(sequence1, separator);
        StringTokenizer components2 = _Comparators_SequenceCompare.tokenizerFor(sequence2, separator);
        int length1 = components1.countTokens();
        int length2 = components2.countTokens();
        if (length1 == 0 && length2 == 0) {
            return 0;
        }
        int n = 0;
        int length;
        while (length1 >= (length = n + 1) || length2 < length) {
            if (length2 < length && length1 >= length) {
                return 1;
            }
            if (length1 < length && length2 < length) {
                return 0;
            }
            String token1 = components1.nextToken();
            String token2 = components2.nextToken();
            int componentCompare = 0;
            OptionalInt int1 = _Ints.parseInt(token1, 10);
            OptionalInt int2 = _Ints.parseInt(token2, 10);
            componentCompare = int1.isPresent() && int2.isPresent() ? Integer.compare(int1.getAsInt(), int2.getAsInt()) : token1.compareTo(token2);
            if (componentCompare != 0) {
                return componentCompare;
            }
            ++n;
        }
        return -1;
    }

    private static StringTokenizer tokenizerFor(String sequence, String separator) {
        return new StringTokenizer(sequence, separator, false);
    }
}

