/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.base;

import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.IntUnaryOperator;
import java.util.function.LongUnaryOperator;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import lombok.NonNull;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.springframework.lang.Nullable;

public final class _Refs {
    public static BooleanReference booleanRef(boolean value) {
        return new BooleanReference(value);
    }

    public static BooleanAtomicReference booleanAtomicRef(boolean value) {
        return new BooleanAtomicReference(value);
    }

    public static IntReference intRef(int value) {
        return new IntReference(value);
    }

    public static LongReference longRef(int value) {
        return new LongReference(value);
    }

    public static <T> ObjectReference<T> objectRef(@Nullable T value) {
        return new ObjectReference<T>(value);
    }

    public static StringReference stringRef(@NonNull String value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return new StringReference(value);
    }

    public static final class BooleanReference {
        private boolean value;

        public boolean update(@NonNull BooleanUnaryOperator operator) {
            if (operator == null) {
                throw new NullPointerException("operator is marked non-null but is null");
            }
            this.value = operator.applyAsBoolean(this.value);
            return this.value;
        }

        public boolean isTrue() {
            return this.value;
        }

        public boolean isFalse() {
            return !this.value;
        }

        public boolean isValue() {
            return this.value;
        }

        public void setValue(boolean value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BooleanReference)) {
                return false;
            }
            BooleanReference other = (BooleanReference)o;
            return this.isValue() == other.isValue();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isValue() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "_Refs.BooleanReference(value=" + this.isValue() + ")";
        }

        public BooleanReference(boolean value) {
            this.value = value;
        }
    }

    public static final class BooleanAtomicReference
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private boolean value;
        private final Object $lock = new Object[0];

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean compute(@NonNull BooleanUnaryOperator operator) {
            if (operator == null) {
                throw new NullPointerException("operator is marked non-null but is null");
            }
            Object object = this.$lock;
            synchronized (object) {
                this.value = operator.applyAsBoolean(this.value);
                return this.value;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean computeIfFalse(@NonNull BooleanSupplier supplier) {
            if (supplier == null) {
                throw new NullPointerException("supplier is marked non-null but is null");
            }
            Object object = this.$lock;
            synchronized (object) {
                return !this.value ? (this.value = supplier.getAsBoolean()) : true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean computeIfTrue(@NonNull BooleanSupplier supplier) {
            if (supplier == null) {
                throw new NullPointerException("supplier is marked non-null but is null");
            }
            Object object = this.$lock;
            synchronized (object) {
                return this.value ? (this.value = supplier.getAsBoolean()) : false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isTrue() {
            Object object = this.$lock;
            synchronized (object) {
                return this.value;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isFalse() {
            Object object = this.$lock;
            synchronized (object) {
                return !this.value;
            }
        }

        public boolean equals(Object obj) {
            return obj instanceof BooleanAtomicReference ? this.isTrue() == ((BooleanAtomicReference)obj).isTrue() : false;
        }

        public int hashCode() {
            return this.isTrue() ? 1 : -1;
        }

        public BooleanAtomicReference(boolean value) {
            this.value = value;
        }
    }

    public static final class IntReference {
        private int value;

        public int update(@NonNull IntUnaryOperator operator) {
            if (operator == null) {
                throw new NullPointerException("operator is marked non-null but is null");
            }
            this.value = operator.applyAsInt(this.value);
            return this.value;
        }

        public boolean isSet(int other) {
            return this.value == other;
        }

        public int incAndGet() {
            return ++this.value;
        }

        public int decAndGet() {
            return --this.value;
        }

        public int getAndInc() {
            return this.value++;
        }

        public int getAndDec() {
            return this.value--;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IntReference)) {
                return false;
            }
            IntReference other = (IntReference)o;
            return this.getValue() == other.getValue();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getValue();
            return result;
        }

        public String toString() {
            return "_Refs.IntReference(value=" + this.getValue() + ")";
        }

        public IntReference(int value) {
            this.value = value;
        }
    }

    public static final class LongReference {
        private long value;

        public long update(@NonNull LongUnaryOperator operator) {
            if (operator == null) {
                throw new NullPointerException("operator is marked non-null but is null");
            }
            this.value = operator.applyAsLong(this.value);
            return this.value;
        }

        public boolean isSet(long other) {
            return this.value == other;
        }

        public long inc() {
            return ++this.value;
        }

        public long dec() {
            return --this.value;
        }

        public long getValue() {
            return this.value;
        }

        public void setValue(long value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LongReference)) {
                return false;
            }
            LongReference other = (LongReference)o;
            return this.getValue() == other.getValue();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $value = this.getValue();
            result = result * 59 + (int)($value >>> 32 ^ $value);
            return result;
        }

        public String toString() {
            return "_Refs.LongReference(value=" + this.getValue() + ")";
        }

        public LongReference(long value) {
            this.value = value;
        }
    }

    public static final class ObjectReference<T> {
        @Nullable
        private T value;

        public T set(@Nullable T value) {
            this.value = value;
            return this.value;
        }

        public T update(@NonNull UnaryOperator<T> operator) {
            if (operator == null) {
                throw new NullPointerException("operator is marked non-null but is null");
            }
            this.value = operator.apply(this.value);
            return this.value;
        }

        public T computeIfAbsent(@NonNull Supplier<T> factory) {
            if (factory == null) {
                throw new NullPointerException("factory is marked non-null but is null");
            }
            return this.value != null ? this.value : this.set(factory.get());
        }

        public boolean isNull() {
            return this.value == null;
        }

        public boolean isNotNull() {
            return this.value != null;
        }

        public boolean isSet(@Nullable T other) {
            return this.value == other;
        }

        public Optional<T> getValue() {
            return Optional.ofNullable(this.value);
        }

        public T getValueElseGet(Supplier<? extends T> other) {
            return this.getValue().orElseGet(other);
        }

        public T getValueElseDefault(T defaultValue) {
            return this.getValue().orElse(defaultValue);
        }

        public T getValueElseFail() {
            return this.getValue().orElseThrow(_Exceptions::noSuchElement);
        }

        public void setValue(@Nullable T value) {
            this.value = value;
        }

        public String toString() {
            return "_Refs.ObjectReference(value=" + this.getValue() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ObjectReference)) {
                return false;
            }
            ObjectReference other = (ObjectReference)o;
            Optional<T> this$value = this.getValue();
            Optional<T> other$value = other.getValue();
            return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Optional<T> $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
            return result;
        }

        public ObjectReference(@Nullable T value) {
            this.value = value;
        }
    }

    public static final class StringReference {
        @NonNull
        private String value;

        public StringReference update(@NonNull UnaryOperator<String> operator) {
            if (operator == null) {
                throw new NullPointerException("operator is marked non-null but is null");
            }
            this.value = Objects.requireNonNull((String)operator.apply(this.value));
            return this;
        }

        public boolean isSet(String other) {
            return this.value.equals(other);
        }

        public String getValue() {
            return this.value;
        }

        public boolean contains(CharSequence s) {
            return this.value.contains(s);
        }

        public void setValue(@NonNull String value) {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            this.value = value;
        }

        public String toString() {
            return "_Refs.StringReference(value=" + this.getValue() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StringReference)) {
                return false;
            }
            StringReference other = (StringReference)o;
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public StringReference(@NonNull String value) {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            this.value = value;
        }
    }

    @FunctionalInterface
    public static interface BooleanUnaryOperator {
        public boolean applyAsBoolean(boolean var1);
    }
}

