/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.io;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import org.apache.causeway.commons.functional.Try;
import org.apache.causeway.commons.io.DataSink;
import org.apache.causeway.commons.io.DataSource;
import org.apache.causeway.commons.io.JsonUtils;
import org.springframework.lang.Nullable;
import org.yaml.snakeyaml.DumperOptions;

public final class YamlUtils {
    public static <T> Try<T> tryRead(@NonNull Class<T> mappedType, @Nullable String stringUtf8, JsonUtils.JacksonCustomizer ... customizers) {
        if (mappedType == null) {
            throw new NullPointerException("mappedType is marked non-null but is null");
        }
        return YamlUtils.tryRead(mappedType, DataSource.ofStringUtf8(stringUtf8), customizers);
    }

    public static <T> Try<T> tryRead(@NonNull Class<T> mappedType, @NonNull DataSource source, JsonUtils.JacksonCustomizer ... customizers) {
        if (mappedType == null) {
            throw new NullPointerException("mappedType is marked non-null but is null");
        }
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        return source.tryReadAll(is -> Try.call(() -> YamlUtils.createJacksonReader(customizers).readValue(is, mappedType)));
    }

    public static void write(@Nullable Object pojo, @NonNull DataSink sink, JsonUtils.JacksonCustomizer ... customizers) {
        if (sink == null) {
            throw new NullPointerException("sink is marked non-null but is null");
        }
        if (pojo == null) {
            return;
        }
        sink.writeAll(os -> Try.run(() -> YamlUtils.createJacksonWriter(customizers).writeValue(os, pojo)));
    }

    @Nullable
    public static String toStringUtf8(@Nullable Object pojo, JsonUtils.JacksonCustomizer ... customizers) {
        return pojo != null ? YamlUtils.createJacksonWriter(customizers).writeValueAsString(pojo) : null;
    }

    public static DumperOptions allowReadOnlyProperties(DumperOptions opts) {
        opts.setAllowReadOnlyProperties(true);
        return opts;
    }

    private static ObjectMapper createJacksonReader(JsonUtils.JacksonCustomizer ... customizers) {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        mapper = JsonUtils.jdk8Support(mapper);
        mapper = JsonUtils.readingJavaTimeSupport(mapper);
        mapper = JsonUtils.readingCanSupport(mapper);
        for (JsonUtils.JacksonCustomizer customizer : customizers) {
            mapper = Optional.ofNullable((ObjectMapper)customizer.apply(mapper)).orElse(mapper);
        }
        return mapper;
    }

    private static ObjectMapper createJacksonWriter(JsonUtils.JacksonCustomizer ... customizers) {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory().disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER));
        mapper = JsonUtils.jdk8Support(mapper);
        mapper = JsonUtils.writingJavaTimeSupport(mapper);
        mapper = JsonUtils.writingCanSupport(mapper);
        for (JsonUtils.JacksonCustomizer customizer : customizers) {
            mapper = Optional.ofNullable((ObjectMapper)customizer.apply(mapper)).orElse(mapper);
        }
        return mapper;
    }

    @Generated
    private YamlUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

