/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.debug.xray.graphics;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.internal.base._Refs;
import org.apache.causeway.commons.internal.base._Text;
import org.apache.causeway.commons.io.TextUtils;

final class _Graphics {
    static final Color COLOR_LIGHTER_GREEN = new Color(213, 232, 212);
    static final Color COLOR_DARKER_GREEN = new Color(130, 179, 102);
    static final Color COLOR_DARKER_RED = new Color(178, 0, 0);
    static final BasicStroke STROKE_DEFAULT = new BasicStroke(1.0f);
    static final BasicStroke STROKE_DASHED = new BasicStroke(1.0f, 0, 1, 1.0f, new float[]{2.0f, 0.0f, 2.0f}, 2.0f);

    _Graphics() {
    }

    static Optional<Font> lookupFont(String fontName, float size) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (Font font : ge.getAllFonts()) {
            if (!font.getFontName().equals(fontName)) continue;
            return Optional.of(font.deriveFont(size));
        }
        return Optional.empty();
    }

    static void arrowHorizontal(Graphics2D g, int m0, int m1, int y) {
        g.drawLine(m0, y, m1, y);
        int dir = m1 < m0 ? 1 : -1;
        Stroke origStroke = g.getStroke();
        g.setStroke(STROKE_DEFAULT);
        for (int i = 0; i < 7; ++i) {
            g.drawLine(m1 + i * dir, y, m1 + 8 * dir, y - 3);
            g.drawLine(m1 + i * dir, y, m1 + 8 * dir, y + 3);
        }
        g.setStroke(origStroke);
    }

    static void enableTextAntialiasing(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        Map desktopHints = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
        if (desktopHints != null) {
            g.setRenderingHints(desktopHints);
        }
    }

    static class TextBlock {
        final String label;
        Can<String> lines;
        final int xLeft;
        int xRight;
        int width;
        final int yTop;
        int yBottom;
        int height;
        int hPadding;
        int vPadding;
        int lineGap;
        int lineAscent;
        int lineDescent;
        int lineHeight;

        Dimension layout(FontMetrics metrics, int hPadding, int vPadding, int lineGap, int maxCharsPerLine) {
            this.hPadding = hPadding;
            this.vPadding = vPadding;
            this.lineGap = lineGap;
            this.lines = _Text.breakLines(TextUtils.readLines(this.label), maxCharsPerLine);
            if (this.lines.isEmpty()) {
                return new Dimension(0, 0);
            }
            this.lineHeight = metrics.getHeight();
            this.lineAscent = metrics.getAscent();
            this.lineDescent = metrics.getDescent();
            int maxAdvance = this.lines.stream().mapToInt(metrics::stringWidth).max().orElse(0);
            this.width = maxAdvance + 2 * hPadding;
            this.height = this.lines.size() * this.lineHeight + (this.lines.size() - 1) * lineGap + 2 * vPadding;
            this.xRight = this.xLeft + this.width;
            this.yBottom = this.yTop + this.height;
            return new Dimension(this.width, this.height);
        }

        void render(Graphics2D g) {
            if (this.lines == null || this.lines.isEmpty()) {
                return;
            }
            int textLeft = this.xLeft + this.hPadding;
            _Refs.IntReference baseLine = _Refs.intRef(this.yTop + this.vPadding + this.lineAscent);
            this.lines.forEach(line -> {
                g.drawString((String)line, textLeft, baseLine.getValue());
                baseLine.update(x -> x + this.lineHeight + this.lineGap);
            });
        }

        @Generated
        public String getLabel() {
            return this.label;
        }

        @Generated
        public Can<String> getLines() {
            return this.lines;
        }

        @Generated
        public int getXLeft() {
            return this.xLeft;
        }

        @Generated
        public int getXRight() {
            return this.xRight;
        }

        @Generated
        public int getWidth() {
            return this.width;
        }

        @Generated
        public int getYTop() {
            return this.yTop;
        }

        @Generated
        public int getYBottom() {
            return this.yBottom;
        }

        @Generated
        public int getHeight() {
            return this.height;
        }

        @Generated
        public int getHPadding() {
            return this.hPadding;
        }

        @Generated
        public int getVPadding() {
            return this.vPadding;
        }

        @Generated
        public int getLineGap() {
            return this.lineGap;
        }

        @Generated
        public int getLineAscent() {
            return this.lineAscent;
        }

        @Generated
        public int getLineDescent() {
            return this.lineDescent;
        }

        @Generated
        public int getLineHeight() {
            return this.lineHeight;
        }

        @Generated
        public TextBlock(String label, int xLeft, int yTop) {
            this.label = label;
            this.xLeft = xLeft;
            this.yTop = yTop;
        }
    }
}

