/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.debug.xray;

import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import lombok.Generated;
import lombok.NonNull;
import org.apache.causeway.commons.internal.collections._Maps;
import org.apache.causeway.commons.internal.debug.xray.XrayDataModel;
import org.apache.causeway.commons.internal.debug.xray.XrayModel;

final class XrayModelSimple
implements XrayModel {
    private final MutableTreeNode rootNode;
    private final Map<String, MutableTreeNode> nodesById = _Maps.newConcurrentHashMap();
    private final Map<String, Stack<MutableTreeNode>> nodeStacksById = _Maps.newConcurrentHashMap();

    @Override
    public MutableTreeNode addContainerNode(@NonNull MutableTreeNode parent, final @NonNull String name, final @NonNull String id, final @NonNull XrayModel.Stickiness stickiness) {
        if (parent == null) {
            throw new NullPointerException("parent is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (stickiness == null) {
            throw new NullPointerException("stickiness is marked non-null but is null");
        }
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode();
        newNode.setUserObject(new XrayModel.HasIdAndLabel(){

            @Override
            public String getId() {
                return id;
            }

            @Override
            public String getLabel() {
                return name;
            }

            @Override
            public XrayModel.Stickiness getStickiness() {
                return stickiness;
            }
        });
        ((DefaultMutableTreeNode)parent).add(newNode);
        this.nodesById.put(id, newNode);
        return newNode;
    }

    @Override
    public <T extends XrayDataModel> T addDataNode(@NonNull MutableTreeNode parent, @NonNull T dataModel) {
        if (parent == null) {
            throw new NullPointerException("parent is marked non-null but is null");
        }
        if (dataModel == null) {
            throw new NullPointerException("dataModel is marked non-null but is null");
        }
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode();
        newNode.setUserObject(dataModel);
        ((DefaultMutableTreeNode)parent).add(newNode);
        this.nodesById.put(dataModel.getId(), newNode);
        return dataModel;
    }

    @Override
    public Optional<MutableTreeNode> lookupNode(String id) {
        return Optional.ofNullable(this.nodesById.get(id));
    }

    @Override
    public void remove(MutableTreeNode node) {
        XrayModel.HasIdAndLabel hasId = (XrayModel.HasIdAndLabel)((DefaultMutableTreeNode)node).getUserObject();
        this.nodesById.remove(hasId.getId());
    }

    @Override
    public Stack<MutableTreeNode> getNodeStack(String id) {
        return this.nodeStacksById.computeIfAbsent(id, __ -> new Stack());
    }

    @Generated
    public XrayModelSimple(MutableTreeNode rootNode) {
        this.rootNode = rootNode;
    }

    @Override
    @Generated
    public MutableTreeNode getRootNode() {
        return this.rootNode;
    }
}

