/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.graph;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import lombok.NonNull;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.collections.ImmutableEnumSet;
import org.apache.causeway.commons.functional.IndexedConsumer;
import org.apache.causeway.commons.internal.assertions._Assert;
import org.apache.causeway.commons.internal.collections._PrimitiveCollections;
import org.springframework.lang.Nullable;

public final class GraphUtils {
    public static <T> GraphKernel kernelForAdjacency(Can<T> nodes, BiPredicate<T, T> adjaciency) {
        GraphKernel kernel = new GraphKernel(nodes.size(), ImmutableEnumSet.noneOf(GraphKernel.GraphCharacteristic.class));
        int m = nodes.size() - 1;
        int n = nodes.size();
        for (int i = 0; i < m; ++i) {
            T a = nodes.getElseFail(i);
            for (int j = i; j < n; ++j) {
                T b = nodes.getElseFail(j);
                if (adjaciency.test(a, b)) {
                    kernel.addEdge(i, j);
                }
                if (!adjaciency.test(b, a)) continue;
                kernel.addEdge(j, i);
            }
        }
        return kernel;
    }

    @Generated
    private GraphUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static final class GraphKernel {
        private final ImmutableEnumSet<GraphCharacteristic> characteristics;
        private final int nodeCount;
        private final List<_PrimitiveCollections.IntList> adjacencyList;

        public GraphKernel(int nodeCount, @NonNull ImmutableEnumSet<GraphCharacteristic> characteristics) {
            if (characteristics == null) {
                throw new NullPointerException("characteristics is marked non-null but is null");
            }
            this.characteristics = characteristics;
            this.nodeCount = nodeCount;
            this.adjacencyList = new ArrayList<_PrimitiveCollections.IntList>(nodeCount);
            for (int i = 0; i < nodeCount; ++i) {
                this.adjacencyList.add(new _PrimitiveCollections.IntList());
            }
        }

        public boolean isUndirected() {
            return this.characteristics.contains(GraphCharacteristic.UNDIRECTED);
        }

        public int edgeCount() {
            return this.adjacencyList.stream().mapToInt(_PrimitiveCollections.IntList::size).sum();
        }

        public void addEdge(int u, int v) {
            this.boundsCheck(u);
            this.boundsCheck(v);
            this.adjacencyList.get(u).addUnique(v);
            if (this.isUndirected()) {
                this.adjacencyList.get(v).addUnique(u);
            }
        }

        public IntStream streamNeighbors(int nodeIndex) {
            this.boundsCheck(nodeIndex);
            return this.adjacencyList.get(nodeIndex).stream();
        }

        public GraphKernel copy() {
            GraphKernel copy = new GraphKernel(this.nodeCount, this.characteristics);
            for (int u = 0; u < this.nodeCount; ++u) {
                for (int v : this.adjacencyList.get(u)) {
                    copy.addEdge(u, v);
                }
            }
            return copy;
        }

        public GraphKernel toUndirected() {
            GraphKernel copy = new GraphKernel(this.nodeCount, this.characteristics.add(GraphCharacteristic.UNDIRECTED));
            for (int u = 0; u < this.nodeCount; ++u) {
                for (int v : this.adjacencyList.get(u)) {
                    copy.addEdge(u, v);
                    copy.addEdge(v, u);
                }
            }
            return copy;
        }

        public GraphKernel subGraph(@Nullable int[] nodeIndexes) {
            _PrimitiveCollections.IntList pickedSubset = new _PrimitiveCollections.IntList(nodeIndexes);
            int subsize = pickedSubset.size();
            GraphKernel sub = new GraphKernel(subsize, this.characteristics);
            for (int i = 0; i < subsize; ++i) {
                int fromIndex = i;
                for (int v : this.adjacencyList.get(nodeIndexes[i])) {
                    pickedSubset.indexOf(v).ifPresent(toIndex -> sub.addEdge(fromIndex, toIndex));
                }
            }
            return sub;
        }

        public List<int[]> findWeaklyConnectedNodes() {
            GraphKernel undirectedGraph = this.isUndirected() ? this : this.toUndirected();
            List<_PrimitiveCollections.IntList> adjacencyList = new WeaklyConnectedNodesFinder().find(undirectedGraph);
            return adjacencyList.stream().filter(_PrimitiveCollections.IntList::isNotEmpty).map(_PrimitiveCollections.IntList::toArray).collect(Collectors.toList());
        }

        private void boundsCheck(int nodeIndex) {
            if (nodeIndex < 0 || nodeIndex >= this.nodeCount) {
                throw new IndexOutOfBoundsException(nodeIndex);
            }
        }

        @Generated
        public int nodeCount() {
            return this.nodeCount;
        }

        public static enum GraphCharacteristic {
            UNDIRECTED;


            public static ImmutableEnumSet<GraphCharacteristic> directed() {
                return ImmutableEnumSet.noneOf(GraphCharacteristic.class);
            }
        }

        private class WeaklyConnectedNodesFinder {
            private WeaklyConnectedNodesFinder() {
            }

            List<_PrimitiveCollections.IntList> find(GraphKernel undirectedGraph) {
                _Assert.assertTrue(undirectedGraph.isUndirected());
                ArrayList<_PrimitiveCollections.IntList> connectedComponents = new ArrayList<_PrimitiveCollections.IntList>();
                boolean[] isVisited = new boolean[undirectedGraph.nodeCount()];
                for (int i = 0; i < undirectedGraph.nodeCount(); ++i) {
                    if (isVisited[i]) continue;
                    _PrimitiveCollections.IntList component = new _PrimitiveCollections.IntList();
                    this.findConnectedComponent(i, isVisited, component, undirectedGraph);
                    connectedComponents.add(component);
                }
                return connectedComponents;
            }

            private void findConnectedComponent(int src, boolean[] isVisited, _PrimitiveCollections.IntList component, GraphKernel undirectedGraph) {
                isVisited[src] = true;
                component.add(src);
                for (int v : undirectedGraph.adjacencyList.get(src)) {
                    if (isVisited[v]) continue;
                    this.findConnectedComponent(v, isVisited, component, undirectedGraph);
                }
            }
        }
    }

    public static class GraphBuilder<T> {
        private final Class<T> nodeType;
        private final ImmutableEnumSet<GraphKernel.GraphCharacteristic> characteristics;
        private final List<T> nodeList;
        private final _PrimitiveCollections.IntList fromNode = new _PrimitiveCollections.IntList(4);
        private final _PrimitiveCollections.IntList toNode = new _PrimitiveCollections.IntList(4);

        public static <T> GraphBuilder<T> directed(Class<T> nodeType) {
            return new GraphBuilder<T>(nodeType, GraphKernel.GraphCharacteristic.directed());
        }

        public GraphBuilder<T> addNode(@NonNull T node) {
            if (node == null) {
                throw new NullPointerException("node is marked non-null but is null");
            }
            this.nodeList.add(node);
            return this;
        }

        public GraphBuilder<T> addEdge(int fromIndex, int toIndex) {
            this.fromNode.add(fromIndex);
            this.toNode.add(toIndex);
            return this;
        }

        public int nodeCount() {
            return this.nodeList.size();
        }

        public int edgeCount() {
            return this.fromNode.size();
        }

        private GraphBuilder(Class<T> nodeType, ImmutableEnumSet<GraphKernel.GraphCharacteristic> characteristics) {
            this.nodeType = nodeType;
            this.characteristics = characteristics;
            this.nodeList = new ArrayList<T>();
        }

        public Graph<T> build() {
            GraphKernel kernel = new GraphKernel(this.nodeList.size(), this.characteristics);
            int edgeCount = this.edgeCount();
            for (int edgeIndex = 0; edgeIndex < edgeCount; ++edgeIndex) {
                kernel.addEdge(this.fromNode.get(edgeIndex), this.toNode.get(edgeIndex));
            }
            Graph<T> graph = new Graph<T>(kernel, Can.ofCollection(this.nodeList));
            return graph;
        }
    }

    public static final class Graph<T> {
        private final GraphKernel kernel;
        private final Can<T> nodes;

        public void visitNeighbors(int nodeIndex, Consumer<T> nodeVisitor) {
            this.kernel().streamNeighbors(nodeIndex).forEach(neighborIndex -> nodeVisitor.accept(this.nodes.getElseFail(neighborIndex)));
        }

        public void visitNeighborsIndexed(int nodeIndex, IndexedConsumer<T> nodeVisitor) {
            this.kernel().streamNeighbors(nodeIndex).forEach(neighborIndex -> nodeVisitor.accept(neighborIndex, this.nodes.getElseFail(neighborIndex)));
        }

        public <R> Graph<R> map(Function<T, R> nodeMapper) {
            return new Graph<R>(this.kernel, this.nodes.map(nodeMapper));
        }

        @Generated
        public Graph(GraphKernel kernel, Can<T> nodes) {
            this.kernel = kernel;
            this.nodes = nodes;
        }

        @Generated
        public GraphKernel kernel() {
            return this.kernel;
        }

        @Generated
        public Can<T> nodes() {
            return this.nodes;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Graph)) {
                return false;
            }
            Graph other = (Graph)o;
            GraphKernel this$kernel = this.kernel();
            GraphKernel other$kernel = other.kernel();
            if (this$kernel == null ? other$kernel != null : !this$kernel.equals(other$kernel)) {
                return false;
            }
            Can<T> this$nodes = this.nodes();
            Can<T> other$nodes = other.nodes();
            return !(this$nodes == null ? other$nodes != null : !this$nodes.equals(other$nodes));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            GraphKernel $kernel = this.kernel();
            result = result * 59 + ($kernel == null ? 43 : $kernel.hashCode());
            Can<T> $nodes = this.nodes();
            result = result * 59 + ($nodes == null ? 43 : $nodes.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "GraphUtils.Graph(kernel=" + this.kernel() + ", nodes=" + this.nodes() + ")";
        }
    }
}

