/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.semantics;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.Vector;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.collections.ImmutableCollection;
import org.apache.causeway.commons.collections.ImmutableEnumSet;
import org.apache.causeway.commons.internal.base._Casts;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.commons.internal.collections._Arrays;
import org.apache.causeway.commons.internal.collections._Collections;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.apache.causeway.commons.semantics.MethodSets;
import org.springframework.lang.Nullable;

public enum CollectionSemantics {
    ARRAY((Class)Array.class, (InvocationHandlingPolicy)MethodSets.EMPTY){

        @Override
        public Object asContainerType(Class<?> elementType, @NonNull List<?> plural) {
            if (plural == null) {
                throw new NullPointerException("plural is marked non-null but is null");
            }
            return _Arrays.toArray((Collection)_Casts.uncheckedCast(plural), elementType);
        }
    }
    ,
    VECTOR((Class)Vector.class, (InvocationHandlingPolicy)MethodSets.LIST){

        @Override
        public Object asContainerType(Class<?> elementType, @NonNull List<?> plural) {
            if (plural == null) {
                throw new NullPointerException("plural is marked non-null but is null");
            }
            return new Vector(plural);
        }
    }
    ,
    LIST((Class)List.class, (InvocationHandlingPolicy)MethodSets.LIST){

        @Override
        public Object asContainerType(Class<?> elementType, @NonNull List<?> plural) {
            if (plural == null) {
                throw new NullPointerException("plural is marked non-null but is null");
            }
            return Collections.unmodifiableList(plural);
        }
    }
    ,
    SORTED_SET((Class)SortedSet.class, (InvocationHandlingPolicy)MethodSets.COLLECTION){

        @Override
        public Object asContainerType(Class<?> elementType, @NonNull List<?> plural) {
            if (plural == null) {
                throw new NullPointerException("plural is marked non-null but is null");
            }
            return _Collections.asUnmodifiableSortedSet(plural);
        }
    }
    ,
    SET((Class)Set.class, (InvocationHandlingPolicy)MethodSets.COLLECTION){

        @Override
        public Object asContainerType(Class<?> elementType, @NonNull List<?> plural) {
            if (plural == null) {
                throw new NullPointerException("plural is marked non-null but is null");
            }
            return _Collections.asUnmodifiableSet(plural);
        }
    }
    ,
    COLLECTION((Class)Collection.class, (InvocationHandlingPolicy)MethodSets.COLLECTION){

        @Override
        public Object asContainerType(Class<?> elementType, @NonNull List<?> plural) {
            if (plural == null) {
                throw new NullPointerException("plural is marked non-null but is null");
            }
            return Collections.unmodifiableCollection(plural);
        }
    }
    ,
    CAN((Class)Can.class, (InvocationHandlingPolicy)MethodSets.CAN){

        @Override
        public Object asContainerType(Class<?> elementType, @NonNull List<?> plural) {
            if (plural == null) {
                throw new NullPointerException("plural is marked non-null but is null");
            }
            return Can.ofCollection(plural);
        }
    }
    ,
    IMMUTABLE_COLLECTION((Class)ImmutableCollection.class, (InvocationHandlingPolicy)MethodSets.COLLECTION){

        @Override
        public Object asContainerType(Class<?> elementType, @NonNull List<?> plural) {
            if (plural == null) {
                throw new NullPointerException("plural is marked non-null but is null");
            }
            return CAN.asContainerType(elementType, plural);
        }
    }
    ,
    MAP((Class)Map.class, (InvocationHandlingPolicy)MethodSets.MAP){

        @Override
        public Object asContainerType(Class<?> elementType, @NonNull List<?> plural) {
            if (plural == null) {
                throw new NullPointerException("plural is marked non-null but is null");
            }
            throw new UnsupportedOperationException("Map is not a collection");
        }
    };

    private final Class<?> containerType;
    private final InvocationHandlingPolicy invocationHandlingPolicy;
    private static final ImmutableEnumSet<CollectionSemantics> all;
    private static final ImmutableEnumSet<CollectionSemantics> typeSubstitutors;

    public boolean isArray() {
        return this == ARRAY;
    }

    public boolean isVector() {
        return this == VECTOR;
    }

    public boolean isList() {
        return this == LIST;
    }

    public boolean isSortedSet() {
        return this == SORTED_SET;
    }

    public boolean isSet() {
        return this == SET;
    }

    public boolean isCollection() {
        return this == COLLECTION;
    }

    public boolean isCan() {
        return this == CAN;
    }

    public boolean isImmutableCollection() {
        return this == IMMUTABLE_COLLECTION;
    }

    public boolean isMap() {
        return this == MAP;
    }

    public boolean isSetAny() {
        return this.isSet() || this.isSortedSet();
    }

    public static Optional<CollectionSemantics> valueOf(@Nullable Class<?> type) {
        if (type == null) {
            return Optional.empty();
        }
        return type.isArray() ? Optional.of(ARRAY) : all.stream().filter(collType -> collType.getContainerType().isAssignableFrom(type)).filter(t -> !t.isMap()).findFirst();
    }

    public static CollectionSemantics valueOfElseFail(@Nullable Class<?> type) {
        return CollectionSemantics.valueOf(type).orElseThrow(() -> _Exceptions.illegalArgument("failed to lookup CollectionSemantics for type %s", type));
    }

    public Object unmodifiableCopyOf(Class<?> elementType, @NonNull Iterable<?> nonScalar) {
        if (nonScalar == null) {
            throw new NullPointerException("nonScalar is marked non-null but is null");
        }
        return this.asContainerType(elementType, _NullSafe.stream(nonScalar).collect(Collectors.toList()));
    }

    protected abstract Object asContainerType(Class<?> var1, @NonNull List<?> var2);

    private CollectionSemantics(Class<?> containerType, InvocationHandlingPolicy invocationHandlingPolicy) {
        this.containerType = containerType;
        this.invocationHandlingPolicy = invocationHandlingPolicy;
    }

    public Class<?> getContainerType() {
        return this.containerType;
    }

    public InvocationHandlingPolicy getInvocationHandlingPolicy() {
        return this.invocationHandlingPolicy;
    }

    public static ImmutableEnumSet<CollectionSemantics> typeSubstitutors() {
        return typeSubstitutors;
    }

    static {
        all = ImmutableEnumSet.allOf(CollectionSemantics.class);
        typeSubstitutors = all.remove(ARRAY);
    }

    public static interface InvocationHandlingPolicy {
        public List<Method> getIntercepted();

        public List<Method> getVetoed();
    }
}

