/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.base;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.internal.assertions._Assert;
import org.apache.causeway.commons.internal.base._Refs;
import org.apache.causeway.commons.internal.collections._Lists;
import org.apache.causeway.commons.io.TextUtils;
import org.springframework.lang.Nullable;

public final class _Text {
    private _Text() {
    }

    public static Can<String> breakLines(Can<String> lines, int maxChars) {
        if (lines.isEmpty()) {
            return lines;
        }
        return lines.stream().flatMap(line -> _Text.breakLine(line, maxChars)).collect(Can.toCan());
    }

    public static String normalize(@Nullable String text) {
        if (text == null) {
            return "";
        }
        return _Text.normalize(TextUtils.readLines(text)).stream().collect(Collectors.joining("\n"));
    }

    public static Can<String> normalize(@NonNull Can<String> lines) {
        if (lines == null) {
            throw new NullPointerException("lines is marked non-null but is null");
        }
        return _Text.removeRepeatedEmptyLines(_Text.removeTrailingEmptyLines(_Text.removeLeadingEmptyLines(lines)));
    }

    public static Can<String> removeLeadingEmptyLines(@NonNull Can<String> lines) {
        if (lines == null) {
            throw new NullPointerException("lines is marked non-null but is null");
        }
        if (lines.isEmpty()) {
            return lines;
        }
        int[] nonEmptyLineCount = new int[]{0};
        return lines.stream().peek(line -> {
            if (_Text.hasNonWhiteSpaceChars(line)) {
                nonEmptyLineCount[0] = nonEmptyLineCount[0] + 1;
            }
        }).filter(line -> nonEmptyLineCount[0] > 0).collect(Can.toCan());
    }

    public static Can<String> removeTrailingEmptyLines(@NonNull Can<String> lines) {
        int lastNonEmptyLineIndex;
        if (lines == null) {
            throw new NullPointerException("lines is marked non-null but is null");
        }
        if (lines.isEmpty()) {
            return lines;
        }
        int lastLineIndex = lines.size() - 1;
        if (lastLineIndex == (lastNonEmptyLineIndex = lines.stream().mapToInt(_Text.indexAndlineToIntFunction((index, line) -> _Text.hasNonWhiteSpaceChars(line) ? index : -1)).max().orElse(-1))) {
            return lines;
        }
        return lines.stream().limit(1L + (long)lastNonEmptyLineIndex).collect(Can.toCan());
    }

    public static Can<String> removeRepeatedEmptyLines(@NonNull Can<String> lines) {
        if (lines == null) {
            throw new NullPointerException("lines is marked non-null but is null");
        }
        if (lines.size() < 2) {
            return lines;
        }
        int[] latestEmptyLineIndex = new int[]{-2};
        return _Text.streamLineObjects(lines).peek(line -> {
            if (!line.isEmpty()) {
                return;
            }
            if (latestEmptyLineIndex[0] == line.getIndex() - 1) {
                line.setMarkedForRemoval(true);
            }
            latestEmptyLineIndex[0] = line.getIndex();
        }).filter(line -> !line.isMarkedForRemoval()).map(Line::getString).collect(Can.toCan());
    }

    public static String abbreviate(@Nullable String input) {
        if (input == null) {
            return input;
        }
        String s = input;
        s = s.replace("org.apache.causeway.", "..causeway.");
        s = s.replace(".viewer.wicket.", "..wkt.");
        return s;
    }

    public static String abbreviate(@Nullable Class<?> cls) {
        if (cls == null) {
            return "[none]";
        }
        return _Text.abbreviate(cls.getCanonicalName());
    }

    public static String abbreviateClassOf(@Nullable Object obj) {
        if (obj == null) {
            return "[none]";
        }
        return _Text.abbreviate(obj.getClass());
    }

    public static void assertTextEquals(@Nullable String a, @Nullable String b) {
        _Text.assertTextEquals(TextUtils.readLines(a), TextUtils.readLines(b));
    }

    public static void assertTextEquals(@NonNull Can<String> a, @Nullable String b) {
        if (a == null) {
            throw new NullPointerException("a is marked non-null but is null");
        }
        _Text.assertTextEquals(a, TextUtils.readLines(b));
    }

    public static void assertTextEquals(@Nullable String a, @NonNull Can<String> b) {
        if (b == null) {
            throw new NullPointerException("b is marked non-null but is null");
        }
        _Text.assertTextEquals(TextUtils.readLines(a), b);
    }

    public static void assertTextEquals(@NonNull Can<String> a, @NonNull Can<String> b) {
        if (a == null) {
            throw new NullPointerException("a is marked non-null but is null");
        }
        if (b == null) {
            throw new NullPointerException("b is marked non-null but is null");
        }
        Can<String> na = _Text.normalize(a);
        Can<String> nb = _Text.normalize(b);
        _Refs.IntReference lineNrRef = _Refs.intRef(0);
        if (na.size() <= nb.size()) {
            na.zip(nb, (left, right) -> {
                int lineNr = lineNrRef.incAndGet();
                _Assert.assertEquals(left, right, () -> String.format("first non matching lineNr %d", lineNr));
            });
        } else {
            nb.zip(na, (right, left) -> {
                int lineNr = lineNrRef.incAndGet();
                _Assert.assertEquals(left, right, () -> String.format("first non matching lineNr %d", lineNr));
            });
        }
        _Assert.assertEquals((Object)na.size(), (Object)nb.size(), () -> String.format("normalized texts differ in number of lines", new Object[0]));
    }

    private static boolean hasNonWhiteSpaceChars(String s) {
        if (s == null) {
            return false;
        }
        return !s.trim().isEmpty();
    }

    private static Stream<Line> streamLineObjects(@NonNull Can<String> lines) {
        if (lines == null) {
            throw new NullPointerException("lines is marked non-null but is null");
        }
        int[] indexRef = new int[]{0};
        return lines.stream().map(line -> {
            int n = indexRef[0];
            indexRef[0] = n + 1;
            return new Line(n, (String)line);
        });
    }

    private static ToIntFunction<String> indexAndlineToIntFunction(IndexAwareLineToIntFunction mapper) {
        int[] indexRef = new int[]{0};
        return line -> {
            int n = indexRef[0];
            indexRef[0] = n + 1;
            return mapper.apply(n, (String)line);
        };
    }

    private static Stream<String> breakLine(String line, int maxChars) {
        if ((line = line.trim()).length() <= maxChars) {
            return Stream.of(line);
        }
        Can<String> tokens = Can.ofEnumeration(new StringTokenizer(line, " .-:/_", true)).map(String.class::cast);
        ArrayList constraintLines = _Lists.newArrayList();
        _Refs.IntReference partialSum = _Refs.intRef(0);
        _Refs.IntReference partialCount = _Refs.intRef(0);
        Iterator tokenIterator = tokens.iterator();
        tokens.stream().mapToInt(String::length).forEach(tokenLen -> {
            int nextLen = partialSum.getValue() + tokenLen;
            if (nextLen <= maxChars) {
                partialSum.update(x -> nextLen);
                partialCount.incAndGet();
            } else {
                constraintLines.add(IntStream.range(0, partialCount.getValue()).mapToObj(__ -> (String)tokenIterator.next()).collect(Collectors.joining()));
                partialSum.update(x -> tokenLen);
                partialCount.setValue(1);
            }
        });
        constraintLines.add(IntStream.range(0, partialCount.getValue()).mapToObj(__ -> (String)tokenIterator.next()).collect(Collectors.joining()));
        return constraintLines.stream();
    }

    private static interface IndexAwareLineToIntFunction {
        public int apply(int var1, String var2);
    }

    private static class Line {
        private final int index;
        private final String string;
        private final boolean empty;
        private boolean markedForRemoval;

        public Line(int index, String string) {
            this.index = index;
            this.string = string;
            this.empty = !_Text.hasNonWhiteSpaceChars(string);
        }

        public int getIndex() {
            return this.index;
        }

        public String getString() {
            return this.string;
        }

        public boolean isEmpty() {
            return this.empty;
        }

        public boolean isMarkedForRemoval() {
            return this.markedForRemoval;
        }

        public void setMarkedForRemoval(boolean markedForRemoval) {
            this.markedForRemoval = markedForRemoval;
        }
    }
}

