/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.functional;

import java.io.Serializable;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.NonNull;

public interface Either<L, R> {
    public static <L, R> Either<L, R> left(@NonNull L left) {
        if (left == null) {
            throw new NullPointerException("left is marked non-null but is null");
        }
        return new Left(left);
    }

    public static <L, R> Either<L, R> right(@NonNull R right) {
        if (right == null) {
            throw new NullPointerException("right is marked non-null but is null");
        }
        return new Right(right);
    }

    public Optional<L> left();

    public Optional<R> right();

    public L leftIfAny();

    public R rightIfAny();

    public boolean isLeft();

    public boolean isRight();

    public <T> Either<T, R> mapLeft(@NonNull Function<L, T> var1);

    public <T> Either<L, T> mapRight(@NonNull Function<R, T> var1);

    public <X, Y> Either<X, Y> map(@NonNull Function<L, X> var1, @NonNull Function<R, Y> var2);

    public <T> T fold(@NonNull BiFunction<L, R, T> var1);

    public <T> T fold(@NonNull Function<L, T> var1, @NonNull Function<R, T> var2);

    public void accept(@NonNull Consumer<L> var1, @NonNull Consumer<R> var2);

    public static final class Left<L, R>
    implements Either<L, R>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final L left;

        @Override
        public Optional<L> left() {
            return Optional.ofNullable(this.left);
        }

        @Override
        public Optional<R> right() {
            return Optional.empty();
        }

        @Override
        public L leftIfAny() {
            return this.left;
        }

        @Override
        public R rightIfAny() {
            return null;
        }

        @Override
        public final boolean isLeft() {
            return true;
        }

        @Override
        public final boolean isRight() {
            return false;
        }

        @Override
        public final <T> Either<T, R> mapLeft(@NonNull Function<L, T> leftMapper) {
            if (leftMapper == null) {
                throw new NullPointerException("leftMapper is marked non-null but is null");
            }
            return Either.left(leftMapper.apply(this.left));
        }

        @Override
        public final <T> Either<L, T> mapRight(@NonNull Function<R, T> rightMapper) {
            if (rightMapper == null) {
                throw new NullPointerException("rightMapper is marked non-null but is null");
            }
            return Either.left(this.left);
        }

        @Override
        public final <X, Y> Either<X, Y> map(@NonNull Function<L, X> leftMapper, @NonNull Function<R, Y> rightMapper) {
            if (leftMapper == null) {
                throw new NullPointerException("leftMapper is marked non-null but is null");
            }
            if (rightMapper == null) {
                throw new NullPointerException("rightMapper is marked non-null but is null");
            }
            return Either.left(leftMapper.apply(this.left));
        }

        @Override
        public final <T> T fold(@NonNull BiFunction<L, R, T> biMapper) {
            if (biMapper == null) {
                throw new NullPointerException("biMapper is marked non-null but is null");
            }
            return biMapper.apply(this.left, null);
        }

        @Override
        public final <T> T fold(@NonNull Function<L, T> leftMapper, @NonNull Function<R, T> rightMapper) {
            if (leftMapper == null) {
                throw new NullPointerException("leftMapper is marked non-null but is null");
            }
            if (rightMapper == null) {
                throw new NullPointerException("rightMapper is marked non-null but is null");
            }
            return leftMapper.apply(this.left);
        }

        @Override
        public final void accept(@NonNull Consumer<L> leftConsumer, @NonNull Consumer<R> rightConsumer) {
            if (leftConsumer == null) {
                throw new NullPointerException("leftConsumer is marked non-null but is null");
            }
            if (rightConsumer == null) {
                throw new NullPointerException("rightConsumer is marked non-null but is null");
            }
            leftConsumer.accept(this.left);
        }

        public L getLeft() {
            return this.left;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Left)) {
                return false;
            }
            Left other = (Left)o;
            L this$left = this.getLeft();
            L other$left = other.getLeft();
            return !(this$left == null ? other$left != null : !this$left.equals(other$left));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            L $left = this.getLeft();
            result = result * 59 + ($left == null ? 43 : $left.hashCode());
            return result;
        }

        public String toString() {
            return "Either.Left(left=" + this.getLeft() + ")";
        }

        protected Left(L left) {
            this.left = left;
        }
    }

    public static final class Right<L, R>
    implements Either<L, R>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final R right;

        @Override
        public Optional<L> left() {
            return Optional.empty();
        }

        @Override
        public Optional<R> right() {
            return Optional.ofNullable(this.right);
        }

        @Override
        public L leftIfAny() {
            return null;
        }

        @Override
        public R rightIfAny() {
            return this.right;
        }

        @Override
        public final boolean isLeft() {
            return false;
        }

        @Override
        public final boolean isRight() {
            return true;
        }

        @Override
        public final <T> Either<T, R> mapLeft(@NonNull Function<L, T> leftMapper) {
            if (leftMapper == null) {
                throw new NullPointerException("leftMapper is marked non-null but is null");
            }
            return Either.right(this.right);
        }

        @Override
        public final <T> Either<L, T> mapRight(@NonNull Function<R, T> rightMapper) {
            if (rightMapper == null) {
                throw new NullPointerException("rightMapper is marked non-null but is null");
            }
            return Either.right(rightMapper.apply(this.right));
        }

        @Override
        public final <X, Y> Either<X, Y> map(@NonNull Function<L, X> leftMapper, @NonNull Function<R, Y> rightMapper) {
            if (leftMapper == null) {
                throw new NullPointerException("leftMapper is marked non-null but is null");
            }
            if (rightMapper == null) {
                throw new NullPointerException("rightMapper is marked non-null but is null");
            }
            return Either.right(rightMapper.apply(this.right));
        }

        @Override
        public final <T> T fold(@NonNull BiFunction<L, R, T> biMapper) {
            if (biMapper == null) {
                throw new NullPointerException("biMapper is marked non-null but is null");
            }
            return biMapper.apply(null, this.right);
        }

        @Override
        public final <T> T fold(@NonNull Function<L, T> leftMapper, @NonNull Function<R, T> rightMapper) {
            if (leftMapper == null) {
                throw new NullPointerException("leftMapper is marked non-null but is null");
            }
            if (rightMapper == null) {
                throw new NullPointerException("rightMapper is marked non-null but is null");
            }
            return rightMapper.apply(this.right);
        }

        @Override
        public final void accept(@NonNull Consumer<L> leftConsumer, @NonNull Consumer<R> rightConsumer) {
            if (leftConsumer == null) {
                throw new NullPointerException("leftConsumer is marked non-null but is null");
            }
            if (rightConsumer == null) {
                throw new NullPointerException("rightConsumer is marked non-null but is null");
            }
            rightConsumer.accept(this.right);
        }

        public R getRight() {
            return this.right;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Right)) {
                return false;
            }
            Right other = (Right)o;
            R this$right = this.getRight();
            R other$right = other.getRight();
            return !(this$right == null ? other$right != null : !this$right.equals(other$right));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            R $right = this.getRight();
            result = result * 59 + ($right == null ? 43 : $right.hashCode());
            return result;
        }

        public String toString() {
            return "Either.Right(right=" + this.getRight() + ")";
        }

        protected Right(R right) {
            this.right = right;
        }
    }

    @FunctionalInterface
    public static interface HasEither<L, R>
    extends Either<L, R> {
        public Either<L, R> getEither();

        @Override
        default public Optional<L> left() {
            return this.getEither().left();
        }

        @Override
        default public Optional<R> right() {
            return this.getEither().right();
        }

        @Override
        default public L leftIfAny() {
            return this.getEither().leftIfAny();
        }

        @Override
        default public R rightIfAny() {
            return this.getEither().rightIfAny();
        }

        @Override
        default public boolean isLeft() {
            return this.getEither().isLeft();
        }

        @Override
        default public boolean isRight() {
            return this.getEither().isRight();
        }

        @Override
        default public <T> Either<T, R> mapLeft(@NonNull Function<L, T> leftMapper) {
            if (leftMapper == null) {
                throw new NullPointerException("leftMapper is marked non-null but is null");
            }
            return this.getEither().mapLeft(leftMapper);
        }

        @Override
        default public <T> Either<L, T> mapRight(@NonNull Function<R, T> rightMapper) {
            if (rightMapper == null) {
                throw new NullPointerException("rightMapper is marked non-null but is null");
            }
            return this.getEither().mapRight(rightMapper);
        }

        @Override
        default public <X, Y> Either<X, Y> map(@NonNull Function<L, X> leftMapper, @NonNull Function<R, Y> rightMapper) {
            if (leftMapper == null) {
                throw new NullPointerException("leftMapper is marked non-null but is null");
            }
            if (rightMapper == null) {
                throw new NullPointerException("rightMapper is marked non-null but is null");
            }
            return this.getEither().map(leftMapper, rightMapper);
        }

        @Override
        default public <T> T fold(@NonNull BiFunction<L, R, T> biMapper) {
            if (biMapper == null) {
                throw new NullPointerException("biMapper is marked non-null but is null");
            }
            return this.getEither().fold(biMapper);
        }

        @Override
        default public <T> T fold(@NonNull Function<L, T> leftMapper, @NonNull Function<R, T> rightMapper) {
            if (leftMapper == null) {
                throw new NullPointerException("leftMapper is marked non-null but is null");
            }
            if (rightMapper == null) {
                throw new NullPointerException("rightMapper is marked non-null but is null");
            }
            return this.getEither().fold(leftMapper, rightMapper);
        }

        @Override
        default public void accept(@NonNull Consumer<L> leftConsumer, @NonNull Consumer<R> rightConsumer) {
            if (leftConsumer == null) {
                throw new NullPointerException("leftConsumer is marked non-null but is null");
            }
            if (rightConsumer == null) {
                throw new NullPointerException("rightConsumer is marked non-null but is null");
            }
            this.getEither().accept(leftConsumer, rightConsumer);
        }
    }
}

