/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.io;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Optional;
import java.util.function.UnaryOperator;
import lombok.NonNull;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.functional.Try;
import org.apache.causeway.commons.io.DataSink;
import org.apache.causeway.commons.io.DataSource;
import org.springframework.lang.Nullable;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;

public final class YamlUtils {
    public static <T> Try<T> tryRead(@NonNull Class<T> mappedType, @Nullable String stringUtf8, YamlLoadCustomizer ... customizers) {
        if (mappedType == null) {
            throw new NullPointerException("mappedType is marked non-null but is null");
        }
        return YamlUtils.tryRead(mappedType, DataSource.ofStringUtf8(stringUtf8), customizers);
    }

    public static <T> Try<T> tryRead(@NonNull Class<T> mappedType, @NonNull DataSource source, YamlLoadCustomizer ... customizers) {
        if (mappedType == null) {
            throw new NullPointerException("mappedType is marked non-null but is null");
        }
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        return source.tryReadAll(is -> Try.call(() -> YamlUtils.createMapper(mappedType, Can.ofArray(customizers), Can.empty()).load(is)));
    }

    public static void write(@Nullable Object pojo, @NonNull DataSink sink, YamlDumpCustomizer ... customizers) {
        if (sink == null) {
            throw new NullPointerException("sink is marked non-null but is null");
        }
        if (pojo == null) {
            return;
        }
        sink.writeAll(os -> Try.run(() -> YamlUtils.createMapper(pojo.getClass(), Can.empty(), Can.ofArray(customizers)).dump(pojo, (Writer)new OutputStreamWriter((OutputStream)os))));
    }

    @Nullable
    public static String toStringUtf8(@Nullable Object pojo, YamlDumpCustomizer ... customizers) {
        return pojo != null ? YamlUtils.createMapper(pojo.getClass(), Can.empty(), Can.ofArray(customizers)).dump(pojo) : null;
    }

    public static DumperOptions allowReadOnlyProperties(DumperOptions opts) {
        opts.setAllowReadOnlyProperties(true);
        return opts;
    }

    private static Yaml createMapper(Class<?> mappedType, Can<YamlLoadCustomizer> loadCustomizers, Can<YamlDumpCustomizer> dumpCustomizers) {
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setIndent(2);
        dumperOptions.setLineBreak(DumperOptions.LineBreak.UNIX);
        for (YamlDumpCustomizer customizer : dumpCustomizers) {
            dumperOptions = Optional.ofNullable((DumperOptions)customizer.apply(dumperOptions)).orElse(dumperOptions);
        }
        Representer presenter = new Representer(dumperOptions);
        presenter.addClassTag(mappedType, Tag.MAP);
        LoaderOptions loaderOptions = new LoaderOptions();
        for (YamlLoadCustomizer customizer : loadCustomizers) {
            loaderOptions = Optional.ofNullable((LoaderOptions)customizer.apply(loaderOptions)).orElse(loaderOptions);
        }
        Yaml mapper = new Yaml((BaseConstructor)new Constructor(mappedType, loaderOptions), presenter, dumperOptions, loaderOptions);
        return mapper;
    }

    private YamlUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @FunctionalInterface
    public static interface YamlLoadCustomizer
    extends UnaryOperator<LoaderOptions> {
    }

    @FunctionalInterface
    public static interface YamlDumpCustomizer
    extends UnaryOperator<DumperOptions> {
    }
}

