/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.resources;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.apache.causeway.commons.internal.base._Bytes;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.commons.internal.context._Context;
import org.springframework.lang.Nullable;

public final class _Resources {
    private static final Predicate<String> externalResourcePattern = Pattern.compile("^\\w+?://.*$").asPredicate();

    @Nullable
    public static InputStream load(@NonNull Class<?> contextClass, @NonNull String resourceName) {
        if (contextClass == null) {
            throw new NullPointerException("contextClass is marked non-null but is null");
        }
        if (resourceName == null) {
            throw new NullPointerException("resourceName is marked non-null but is null");
        }
        String absoluteResourceName = _Resources.resolveName(contextClass, resourceName);
        return Optional.ofNullable(contextClass.getResourceAsStream(absoluteResourceName)).orElseGet(() -> _Context.getDefaultClassLoader().getResourceAsStream(absoluteResourceName));
    }

    @Nullable
    public static String loadAsString(@NonNull Class<?> contextClass, @NonNull String resourceName, @NonNull Charset charset) throws IOException {
        if (contextClass == null) {
            throw new NullPointerException("contextClass is marked non-null but is null");
        }
        if (resourceName == null) {
            throw new NullPointerException("resourceName is marked non-null but is null");
        }
        if (charset == null) {
            throw new NullPointerException("charset is marked non-null but is null");
        }
        InputStream inputStream = _Resources.load(contextClass, resourceName);
        return _Strings.ofBytes(_Bytes.of(inputStream), charset);
    }

    @Nullable
    public static String loadAsStringUtf8(@NonNull Class<?> contextClass, @NonNull String resourceName) throws IOException {
        if (contextClass == null) {
            throw new NullPointerException("contextClass is marked non-null but is null");
        }
        if (resourceName == null) {
            throw new NullPointerException("resourceName is marked non-null but is null");
        }
        return _Resources.loadAsString(contextClass, resourceName, StandardCharsets.UTF_8);
    }

    @Nullable
    public static URL getResourceUrl(@NonNull Class<?> contextClass, @NonNull String resourceName) {
        if (contextClass == null) {
            throw new NullPointerException("contextClass is marked non-null but is null");
        }
        if (resourceName == null) {
            throw new NullPointerException("resourceName is marked non-null but is null");
        }
        String absoluteResourceName = _Resources.resolveName(contextClass, resourceName);
        return Optional.ofNullable(contextClass.getResource(absoluteResourceName)).orElseGet(() -> _Context.getDefaultClassLoader().getResource(absoluteResourceName));
    }

    public static boolean isLocalResource(@NonNull String resourcePath) {
        if (resourcePath == null) {
            throw new NullPointerException("resourcePath is marked non-null but is null");
        }
        return !externalResourcePattern.test(resourcePath);
    }

    public static String combinePath(@Nullable String extendee, @Nullable String suffix) {
        return _Strings.combineWithDelimiter(extendee, suffix, "/");
    }

    private static String resolveName(Class<?> contextClass, String name) {
        if (name == null) {
            return name;
        }
        if (!((String)name).startsWith("/")) {
            Class<?> c = contextClass;
            while (c.isArray()) {
                c = c.getComponentType();
            }
            String baseName = c.getName();
            int index = baseName.lastIndexOf(46);
            if (index != -1) {
                name = baseName.substring(0, index).replace('.', '/') + "/" + (String)name;
            }
        } else {
            name = ((String)name).substring(1);
        }
        return name;
    }
}

