/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.primitives;

import java.util.Optional;
import java.util.OptionalInt;
import java.util.PrimitiveIterator;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.stream.IntStream;
import lombok.NonNull;
import org.apache.causeway.commons.internal.assertions._Assert;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.springframework.lang.Nullable;

public final class _Ints {
    private static final Consumer<String> IGNORE_ERRORS = t -> {};

    public static Range rangeClosed(int a, int b) {
        if (a > b) {
            throw _Exceptions.illegalArgument("bounds must be ordered in [%d, %d]", a, b);
        }
        return Range.of(Bound.inclusive(a), Bound.inclusive(b));
    }

    public static Range rangeOpenEnded(int a, int b) {
        if (a == b) {
            return Range.empty();
        }
        if (a >= b) {
            throw _Exceptions.illegalArgument("bounds must be ordered in [%d, %d]", a, b);
        }
        return Range.of(Bound.inclusive(a), Bound.exclusive(b));
    }

    public static OptionalInt parseInt(String s, int radix, Consumer<String> onFailure) {
        long parseResult = _Ints.parseIntElseLongMaxValue(s, radix, onFailure);
        if (_Ints.isParseSuccess(parseResult)) {
            return OptionalInt.of(Math.toIntExact(parseResult));
        }
        return OptionalInt.empty();
    }

    public static OptionalInt parseInt(String s, int radix) {
        return _Ints.parseInt(s, radix, IGNORE_ERRORS);
    }

    private static boolean isParseSuccess(long value) {
        return value != Long.MAX_VALUE;
    }

    private static long parseIntElseLongMaxValue(@Nullable String s, int radix, @NonNull Consumer<String> onFailure) {
        if (onFailure == null) {
            throw new NullPointerException("onFailure is marked non-null but is null");
        }
        if (s == null) {
            onFailure.accept("null");
            return Long.MAX_VALUE;
        }
        if (radix < 2) {
            onFailure.accept("radix " + radix + " less than Character.MIN_RADIX");
            return Long.MAX_VALUE;
        }
        if (radix > 36) {
            onFailure.accept("radix " + radix + " greater than Character.MAX_RADIX");
            return Long.MAX_VALUE;
        }
        boolean negative = false;
        int i = 0;
        int len = s.length();
        int limit = -2147483647;
        if (len > 0) {
            char firstChar = s.charAt(0);
            if (firstChar < '0') {
                if (firstChar == '-') {
                    negative = true;
                    limit = Integer.MIN_VALUE;
                } else if (firstChar != '+') {
                    onFailure.accept(s);
                    return Long.MAX_VALUE;
                }
                if (len == 1) {
                    onFailure.accept(s);
                    return Long.MAX_VALUE;
                }
                ++i;
            }
            int multmin = limit / radix;
            int result = 0;
            while (i < len) {
                int digit;
                if ((digit = Character.digit(s.charAt(i++), radix)) < 0 || result < multmin) {
                    onFailure.accept(s);
                    return Long.MAX_VALUE;
                }
                if ((result *= radix) < limit + digit) {
                    onFailure.accept(s);
                    return Long.MAX_VALUE;
                }
                result -= digit;
            }
            int value = negative ? result : -result;
            return value;
        }
        onFailure.accept(s);
        return Long.MAX_VALUE;
    }

    public static int[] flatten(@NonNull int[][] nested) {
        if (nested == null) {
            throw new NullPointerException("nested is marked non-null but is null");
        }
        int n = nested.length;
        int stride = nested[0].length;
        int[] flattened = new int[n * stride];
        for (int i = 0; i < n; ++i) {
            System.arraycopy(nested[i], 0, flattened, i * stride, stride);
        }
        return flattened;
    }

    public static int[][] partition(@NonNull int[] flattened, int stride) {
        if (flattened == null) {
            throw new NullPointerException("flattened is marked non-null but is null");
        }
        int n = flattened.length / stride;
        _Assert.assertEquals((Object)flattened.length, (Object)(n * stride), () -> "flattened.length must be divisible by stride");
        int[][] nested = new int[n][stride];
        for (int i = 0; i < n; ++i) {
            System.arraycopy(flattened, i * stride, nested[i], 0, stride);
        }
        return nested;
    }

    public static String rowForm(@NonNull int[] array) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return _Ints.rowForm(array, 8, Integer::toString);
    }

    public static String rowForm(@NonNull int[] array, int columnWidth, @NonNull IntFunction<String> cellFormatter) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (cellFormatter == null) {
            throw new NullPointerException("cellFormatter is marked non-null but is null");
        }
        int m = array.length;
        StringBuilder sb = new StringBuilder();
        for (int j = 0; j < m; ++j) {
            int cellValue = array[j];
            String cellStringFull = cellFormatter.apply(cellValue);
            String cellStringTrimmed = _Strings.ellipsifyAtEnd(cellStringFull, columnWidth, "..");
            int spacesCount = columnWidth - cellStringTrimmed.length();
            for (int k = 0; k < spacesCount; ++k) {
                sb.append(' ');
            }
            sb.append(cellStringTrimmed);
        }
        sb.append("\n");
        return sb.toString();
    }

    public static String tableForm(@NonNull int[][] nested) {
        if (nested == null) {
            throw new NullPointerException("nested is marked non-null but is null");
        }
        return _Ints.tableForm(nested, 8, Integer::toString);
    }

    public static String tableForm(@NonNull int[][] nested, int columnWidth, @NonNull IntFunction<String> cellFormatter) {
        if (nested == null) {
            throw new NullPointerException("nested is marked non-null but is null");
        }
        if (cellFormatter == null) {
            throw new NullPointerException("cellFormatter is marked non-null but is null");
        }
        int n = nested.length;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            sb.append(_Ints.rowForm(nested[i], columnWidth, cellFormatter));
        }
        return sb.toString();
    }

    private _Ints() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class Range {
        private final Bound lowerBound;
        private final Bound upperBound;
        private final boolean empty;

        public static Range empty() {
            return new Range(null, null, true);
        }

        public static Range of(@NonNull Bound lowerBound, @NonNull Bound upperBound) {
            if (lowerBound == null) {
                throw new NullPointerException("lowerBound is marked non-null but is null");
            }
            if (upperBound == null) {
                throw new NullPointerException("upperBound is marked non-null but is null");
            }
            return new Range(lowerBound, upperBound, false);
        }

        public boolean contains(int value) {
            boolean isAboveUpper;
            boolean isBelowLower;
            if (this.empty) {
                return false;
            }
            boolean bl = this.lowerBound.isInclusive() ? value < this.lowerBound.getValue() : (isBelowLower = value <= this.lowerBound.getValue());
            if (isBelowLower) {
                return false;
            }
            boolean bl2 = this.upperBound.isInclusive() ? value > this.upperBound.getValue() : (isAboveUpper = value >= this.upperBound.getValue());
            return !isAboveUpper;
        }

        public int bounded(int value) {
            int nearestToUpper;
            int distanceToUpper;
            if (this.empty) {
                return value;
            }
            if (this.contains(value)) {
                return value;
            }
            int nearestToLower = this.nearestToLower();
            int distanceToLower = value - nearestToLower;
            return distanceToLower <= (distanceToUpper = value - (nearestToUpper = this.nearestToUpper())) ? nearestToLower : nearestToUpper;
        }

        private int nearestToLower() {
            if (this.empty) {
                throw _Exceptions.unsupportedOperation();
            }
            return this.lowerBound.isInclusive() ? this.lowerBound.getValue() : this.lowerBound.getValue() + 1;
        }

        private int nearestToUpper() {
            if (this.empty) {
                throw _Exceptions.unsupportedOperation();
            }
            return this.upperBound.isInclusive() ? this.upperBound.getValue() : this.upperBound.getValue() - 1;
        }

        @NonNull
        public Optional<Range> intersect(@NonNull Range other) {
            if (other == null) {
                throw new NullPointerException("other is marked non-null but is null");
            }
            if (this.empty) {
                return Optional.empty();
            }
            int s1 = this.nearestToLower();
            int e1 = this.nearestToUpper();
            int s2 = other.nearestToLower();
            int e2 = other.nearestToUpper();
            if (s2 > e1 || s1 > e2) {
                return Optional.empty();
            }
            return Optional.of(Range.of(Bound.inclusive(Math.max(s1, s2)), Bound.inclusive(Math.min(e1, e2))));
        }

        public String toString() {
            if (this.empty) {
                return "[]";
            }
            return String.format("%s%d,%d%S", Character.valueOf(this.lowerBound.isInclusive() ? (char)'[' : '('), this.lowerBound.getValue(), this.upperBound.getValue(), Character.valueOf(this.upperBound.isInclusive() ? (char)']' : ')'));
        }

        public IntStream stream() {
            if (this.empty) {
                return IntStream.empty();
            }
            return IntStream.rangeClosed(this.nearestToLower(), this.nearestToUpper());
        }

        public PrimitiveIterator.OfInt iterator() {
            if (this.empty) {
                return IntStream.empty().iterator();
            }
            return new PrimitiveIterator.OfInt(){
                int next;
                final int upperIncluded;
                {
                    this.next = this.nearestToLower();
                    this.upperIncluded = this.nearestToUpper();
                }

                @Override
                public int nextInt() {
                    if (!this.hasNext()) {
                        throw _Exceptions.noSuchElement();
                    }
                    int result = this.next++;
                    return result;
                }

                @Override
                public boolean hasNext() {
                    return this.next <= this.upperIncluded;
                }
            };
        }

        private Range(Bound lowerBound, Bound upperBound, boolean empty) {
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
            this.empty = empty;
        }
    }

    public static final class Bound {
        private final int value;
        private final boolean inclusive;

        @NonNull
        public static Bound inclusive(int value) {
            return Bound.of(value, true);
        }

        @NonNull
        public static Bound exclusive(int value) {
            return Bound.of(value, true);
        }

        private Bound(int value, boolean inclusive) {
            this.value = value;
            this.inclusive = inclusive;
        }

        public static Bound of(int value, boolean inclusive) {
            return new Bound(value, inclusive);
        }

        public int getValue() {
            return this.value;
        }

        public boolean isInclusive() {
            return this.inclusive;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Bound)) {
                return false;
            }
            Bound other = (Bound)o;
            if (this.getValue() != other.getValue()) {
                return false;
            }
            return this.isInclusive() == other.isInclusive();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getValue();
            result = result * 59 + (this.isInclusive() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "_Ints.Bound(value=" + this.getValue() + ", inclusive=" + this.isInclusive() + ")";
        }
    }
}

