/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.primitives;

import java.math.BigDecimal;
import java.util.Optional;
import lombok.NonNull;

public final class _Floats {
    public static Optional<Float> convertToFloat(@NonNull Optional<BigDecimal> decimal) {
        if (decimal == null) {
            throw new NullPointerException("decimal is marked non-null but is null");
        }
        return decimal.map(_Floats::convertToFloat);
    }

    public static float convertToFloat(@NonNull BigDecimal decimal) {
        if (decimal == null) {
            throw new NullPointerException("decimal is marked non-null but is null");
        }
        float floatValue = decimal.floatValue();
        if (!Float.isFinite(floatValue)) {
            throw new ArithmeticException("non finite BigDecimal to float conversion");
        }
        return floatValue;
    }

    private _Floats() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

