/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.debug.xray;

import java.util.Optional;
import java.util.Stack;
import java.util.UUID;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.commons.internal.debug.xray.XrayDataModel;
import org.springframework.lang.Nullable;

public interface XrayModel {
    public MutableTreeNode getRootNode();

    default public MutableTreeNode getThreadNode(ThreadMemento threadMemento) {
        return this.lookupNode(threadMemento.getId()).orElseGet(() -> this.addContainerNode(this.getRootNode(), threadMemento.getLabel(), threadMemento.getId(), Stickiness.CAN_DELETE_NODE));
    }

    public MutableTreeNode addContainerNode(MutableTreeNode var1, String var2, String var3, Stickiness var4);

    default public MutableTreeNode addContainerNode(MutableTreeNode parent, String name, Stickiness stickiness) {
        return this.addContainerNode(parent, name, UUID.randomUUID().toString(), stickiness);
    }

    public <T extends XrayDataModel> T addDataNode(MutableTreeNode var1, T var2);

    public Optional<MutableTreeNode> lookupNode(String var1);

    public void remove(MutableTreeNode var1);

    default public Optional<XrayDataModel.Sequence> lookupSequence(@Nullable String sequenceId) {
        return _Strings.isNullOrEmpty(sequenceId) ? Optional.empty() : this.lookupNode(sequenceId).map(node -> (XrayDataModel.Sequence)((DefaultMutableTreeNode)node).getUserObject());
    }

    public Stack<MutableTreeNode> getNodeStack(String var1);

    public static final class ThreadMemento {
        private final String id;
        private final String label;
        private final String multilinelabel;

        public static ThreadMemento fromCurrentThread() {
            Thread ct = Thread.currentThread();
            return ThreadMemento.of(String.format("thread-%d-%s", ct.getId(), ct.getName()), String.format("Thread-%d [%s]", ct.getId(), ct.getName()), String.format("Thread-%d\n%s", ct.getId(), ct.getName()));
        }

        private ThreadMemento(String id, String label, String multilinelabel) {
            this.id = id;
            this.label = label;
            this.multilinelabel = multilinelabel;
        }

        public static ThreadMemento of(String id, String label, String multilinelabel) {
            return new ThreadMemento(id, label, multilinelabel);
        }

        public String getId() {
            return this.id;
        }

        public String getLabel() {
            return this.label;
        }

        public String getMultilinelabel() {
            return this.multilinelabel;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ThreadMemento)) {
                return false;
            }
            ThreadMemento other = (ThreadMemento)o;
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$label = this.getLabel();
            String other$label = other.getLabel();
            if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
                return false;
            }
            String this$multilinelabel = this.getMultilinelabel();
            String other$multilinelabel = other.getMultilinelabel();
            return !(this$multilinelabel == null ? other$multilinelabel != null : !this$multilinelabel.equals(other$multilinelabel));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $label = this.getLabel();
            result = result * 59 + ($label == null ? 43 : $label.hashCode());
            String $multilinelabel = this.getMultilinelabel();
            result = result * 59 + ($multilinelabel == null ? 43 : $multilinelabel.hashCode());
            return result;
        }

        public String toString() {
            return "XrayModel.ThreadMemento(id=" + this.getId() + ", label=" + this.getLabel() + ", multilinelabel=" + this.getMultilinelabel() + ")";
        }
    }

    public static abstract class HasIdAndLabel {
        public abstract String getId();

        public abstract String getLabel();

        public abstract Stickiness getStickiness();

        public final String toString() {
            return this.getLabel();
        }
    }

    public static enum Stickiness {
        CAN_DELETE_NODE,
        CANNOT_DELETE_NODE;


        boolean isCanDeleteNode() {
            return this == CAN_DELETE_NODE;
        }
    }
}

