/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.collections;

import java.lang.reflect.Array;
import java.util.Collections;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.apache.causeway.commons.internal.base._Casts;

class _Arrays_Collector<T>
implements Collector<T, FastList<T>, T[]> {
    private final Class<T> componentType;
    private final int size;

    _Arrays_Collector(Class<T> componentType, int size) {
        this.componentType = componentType;
        this.size = size;
    }

    @Override
    public Supplier<FastList<T>> supplier() {
        return () -> new FastList<T>(this.componentType, this.size);
    }

    @Override
    public BiConsumer<FastList<T>, T> accumulator() {
        return FastList::add;
    }

    @Override
    public BinaryOperator<FastList<T>> combiner() {
        return (a, b) -> a.addAll(b);
    }

    @Override
    public Function<FastList<T>, T[]> finisher() {
        return list -> list.buffer;
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return Collections.emptySet();
    }

    static final class FastList<T> {
        private final T[] buffer;
        private int offset = 0;

        public FastList(Class<T> componentType, int size) {
            this.buffer = (Object[])_Casts.uncheckedCast(Array.newInstance(componentType, size));
        }

        public void add(T x) {
            this.buffer[this.offset++] = x;
        }

        public FastList<T> addAll(FastList<T> x) {
            System.arraycopy(x.buffer, 0, this.buffer, this.offset, x.offset);
            return this;
        }
    }
}

