/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.base;

import java.io.Serializable;
import java.util.Locale;
import java.util.function.Supplier;
import org.apache.logging.log4j.Logger;

public final class _Timing {
    private _Timing() {
    }

    public static StopWatch now() {
        return new StopWatch();
    }

    public static StopWatch atSystemNanos(long startedAtSystemNanos) {
        return new StopWatch(startedAtSystemNanos);
    }

    public static StopWatch run(Runnable runnable) {
        StopWatch watch = _Timing.now();
        runnable.run();
        return watch.stop();
    }

    public static void runVerbose(Logger log, String label, Runnable runnable) {
        StopWatch watch = _Timing.run(runnable);
        log.info(String.format(Locale.US, "Running '%s' took %d ms", label, watch.getMillis()));
    }

    public static <T> T callVerbose(Logger log, String label, Supplier<T> callable) {
        StopWatch watch = _Timing.now();
        T result = callable.get();
        watch.stop();
        log.info(String.format(Locale.US, "Calling '%s' took %d ms", label, watch.getMillis()));
        return result;
    }

    public static final class StopWatch
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private long t0 = 0L;
        private long t1 = 0L;
        private boolean stopped;

        private StopWatch(long startedAtSystemNanos) {
            this.t0 = startedAtSystemNanos;
        }

        private StopWatch() {
            this.start();
        }

        public StopWatch start() {
            this.t0 = System.nanoTime();
            this.stopped = false;
            return this;
        }

        public StopWatch stop() {
            this.t1 = System.nanoTime();
            this.stopped = true;
            return this;
        }

        public double getSeconds() {
            return 0.001 * (double)this.getMillis();
        }

        public long getNanos() {
            return this.stopped ? this.t1 - this.t0 : System.nanoTime() - this.t0;
        }

        public long getMicros() {
            return this.getNanos() / 1000L;
        }

        public long getMillis() {
            return this.getNanos() / 1000000L;
        }

        public String toString() {
            return String.format(Locale.US, "%d ms", this.getMillis());
        }

        public boolean isStopped() {
            return this.stopped;
        }
    }
}

