/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.functional;

import java.util.concurrent.Callable;
import lombok.NonNull;
import org.apache.causeway.commons.functional.Try;

@FunctionalInterface
public interface ThrowingRunnable {
    public void run() throws Exception;

    public static Callable<Void> toCallable(@NonNull ThrowingRunnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("runnable is marked non-null but is null");
        }
        return () -> {
            runnable.run();
            return null;
        };
    }

    public static Try<Void> resultOf(@NonNull ThrowingRunnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("runnable is marked non-null but is null");
        }
        return Try.run(runnable);
    }
}

