/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.collections;

import java.util.ArrayList;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.collections.Can_Multiple;

final class _CanFactory {
    static <T> Can<T> ofNonNullElements(ArrayList<T> nonNullElements) {
        if (nonNullElements.isEmpty()) {
            return Can.empty();
        }
        if (nonNullElements.size() == 1) {
            return Can.ofSingleton(nonNullElements.get(0));
        }
        if (nonNullElements.size() > 32) {
            nonNullElements.trimToSize();
        }
        return Can_Multiple.of(nonNullElements);
    }

    static <T> ArrayList<T> arrayListWithSizeUpperBound(int maxSize) {
        return new ArrayList(Math.min(maxSize, 1024));
    }

    static <T> Collector<T, ?, ArrayList<T>> toListWithSizeUpperBound(int maxSize) {
        return Collectors.toCollection(() -> _CanFactory.arrayListWithSizeUpperBound(maxSize));
    }

    private _CanFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

